<?php
use Illuminate\Support\Facades\Auth;
?>
<aside class="sidenav bg-white navbar navbar-vertical navbar-expand-xs border-0 border-radius-xl my-3 
fixed-start ms-4 shadow-lg" id="sidenav-main">
    <div class="sidenav-header">
        <i class="fas fa-times p-3 cursor-pointer text-primary opacity-5 position-absolute end-0 top-0 d-none d-xl-none"
            aria-hidden="true" id="iconSidenav"></i>
        <a class="navbar-brand m-0" href="#" target="_blank">
            <span class="ms-1 font-weight-bold text-center">College Mark System</span>
        </a>
    </div>
    <hr class="horizontal dark mt-0">
    <div class="collapse navbar-collapse w-auto" id="sidenav-collapse-main">
        <ul class="navbar-nav">
            <?php if(Auth::user()->user_type == 'SU'): ?>
            <li class="nav-item">
                <a class="nav-link " href="<?php echo e(url('mark-config')); ?>">
                    <div class="icon icon-shape icon-sm border-radius-md text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="ni ni-tv-2 text-primary text-sm"></i>
                    </div>
                    <span class="nav-link-text ms-1 text-primary">Mark Configuration</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link " href="<?php echo e(url('std-mark')); ?>">
                    <div class="icon icon-shape icon-sm border-radius-md text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="ni ni-tv-2 text-primary text-sm"></i>
                    </div>
                    <span class="nav-link-text ms-1 text-primary">Student Marklist</span>
                </a>
            </li>
            <?php endif; ?>
            <?php if(Auth::user()->user_type == 'SU' || Auth::user()->user_type == 'A'): ?>
            <li class="nav-item">
                <a class="nav-link " href="<?php echo e(url('mark-upload')); ?>">
                    <div class="icon icon-shape icon-sm border-radius-md text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="ni ni-tv-2 text-primary text-sm"></i>
                    </div>
                    <span class="nav-link-text ms-1 text-primary">Mark Upload</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link " href="<?php echo e(url('examlist')); ?>">
                    <div class="icon icon-shape icon-sm border-radius-md text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="ni ni-tv-2 text-primary text-sm"></i>
                    </div>
                    <span class="nav-link-text ms-1 text-primary">Examlist</span>
                </a>
            </li>
            <?php endif; ?>
            <?php if(Auth::user()->user_type == 'S'): ?>
            <li class="nav-item">
                <a class="nav-link " href="<?php echo e(url('mark-report')); ?>">
                    <div class="icon icon-shape icon-sm border-radius-md text-center me-2 d-flex align-items-center justify-content-center">
                        <i class="ni ni-tv-2 text-primary text-sm"></i>
                    </div>
                    <span class="nav-link-text ms-1 text-primary">Mark Report</span>
                </a>
            </li>
            <?php endif; ?>
        </ul>
        <div class="mb-5"></div>
    </div>
</aside><?php /**PATH C:\Users\hp\Desktop\MS\mark-system\resources\views/layouts/navbars/auth/sidenav.blade.php ENDPATH**/ ?>