@php
    use Illuminate\Support\Facades\Auth;
@endphp

@extends('layouts.app', ['class' => 'g-sidenav-show bg-grad'])

@section('content')
@if (Auth::user())
    @include('layouts.navbars.auth.topnav', ['title' => 'Result'])
@endif

<div class="container d-flex justify-content-center align-items-center" style="min-height: 100vh;">
    <div class="col-md-6">
        <form action="{{ route('generate-report') }}" method="GET">
            <div class="card p-4">
                <div class="card-header text-center">
                    <div>Generate Result Report</div>
                </div>
                <div class="card-body">
                    <!-- Filter Options -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="exam">Exam Name</label>
                            <select class="form-control" id="exam" name="exam">
                                <option value="">All Exams</option>
                                @forelse($exams as $data)
                                    <option value="{{$data->id}}" {{ old('exam') == $data->id ? 'selected' : '' }}>
                                        {{$data->exam_name}}
                                    </option>
                                @empty
                                @endforelse
                            </select>
                            @error('exam')
                                <sub class="text-danger">{{$message}}</sub>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="register_number">Register No.</label>
                            <input type="text" class="form-control" id="register_number" name="register_number"
                                placeholder="Enter Register No." value="{{ old('register_number') }}">
                            @error('register_number')
                                <sub class="text-danger">{{$message}}</sub>
                            @enderror
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <label for="semester_filter">Semester</label>
                            <select class="form-control" id="semester_filter" name="semester">
                                <option value="">All Semesters</option>
                                <option value="1" {{ old('semester') == '1' ? 'selected' : '' }}>Semester 1</option>
                                <option value="2" {{ old('semester') == '2' ? 'selected' : '' }}>Semester 2</option>
                                <option value="3" {{ old('semester') == '3' ? 'selected' : '' }}>Semester 3</option>
                                <option value="4" {{ old('semester') == '4' ? 'selected' : '' }}>Semester 4</option>
                                <option value="5" {{ old('semester') == '5' ? 'selected' : '' }}>Semester 5</option>
                                <option value="6" {{ old('semester') == '6' ? 'selected' : '' }}>Semester 6</option>
                            </select>
                            @error('semester')
                                <sub class="text-danger">{{$message}}</sub>
                            @enderror
                        </div>
                    </div>

                    <div class="row align-items-center">
                        <div class="col-md-12 text-center">
                            <button type="submit" class="btn btn-primary mt-3">Generate Report</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
