@extends('layouts.app', ['class' => 'g-sidenav-show bg-grad'])

@section('content')
<div>
    <div class="container">
        <div class="row">
            <div class="col-xl-4 col-lg-5 col-md-6 d-flex flex-column mx-auto">
                <div class="card card-plain mt-8 shadow-lg" style="background-color: rgba(255, 255, 255, 0.8);">
                    <div class="card-header pb-0 text-left bg-transparent" style="background-color: rgba(0, 0, 0, 0.5); color: white;">
                        <h3 class="font-weight-bolder text-primary">Select State and District</h3>
                    </div>
                    <div class="card-body">
                        <!-- Form with static data for State and District -->
                        <form action="#" method="POST" role="form text-left">
                            @csrf
                            
                            <!-- State Selection -->
                            <div class="mb-3">
                                <label for="state">State</label>
                                <div class="@error('state')border border-danger rounded-3 @enderror">
                                    <select name="state" id="state" class="form-select">
                                        <option value="">Select State</option>
                                        <!-- Static state options -->
                                        <option value="1" {{ old('state') == 1 ? 'selected' : '' }}>State A</option>
                                        <option value="2" {{ old('state') == 2 ? 'selected' : '' }}>State B</option>
                                        <option value="3" {{ old('state') == 3 ? 'selected' : '' }}>State C</option>
                                    </select>
                                </div>
                                @error('state') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <!-- District Selection -->
                            <div class="mb-3">
                                <label for="district">District</label>
                                <div class="@error('district')border border-danger rounded-3 @enderror">
                                    <select name="district" id="district" class="form-select">
                                        <option value="">Select District</option>
                                        <!-- Static district options -->
                                        <option value="1" {{ old('district') == 1 ? 'selected' : '' }}>District 1 (State A)</option>
                                        <option value="2" {{ old('district') == 2 ? 'selected' : '' }}>District 2 (State B)</option>
                                        <option value="3" {{ old('district') == 3 ? 'selected' : '' }}>District 3 (State C)</option>
                                    </select>
                                </div>
                                @error('district') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <!-- Submit Button -->
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary w-100 mt-4 mb-0">Proceed</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
