<?php auth()->logout(); ?>
@extends('layouts.app', ['class' => 'g-sidenav-show bg-grad'])

@section('content')
<div>
    <div class="container">
        <div class="row">
            <div class="col-xl-4 col-lg-5 col-md-6 d-flex flex-column mx-auto">
                <div class="card card-plain mt-8 shadow-lg" style="background-color: rgba(255, 255, 255, 0.8);">
                    <div class="card-header pb-0 text-left bg-transparent" style="background-color: rgba(0, 0, 0, 0.5); color: white;">
                        <h3 class="font-weight-bolder text-primary">Welcome back</h3>
                        <p class="mb-0 text-primary">Please enter username and password to sign in.</p>
                    </div>
                    <div class="card-body">
                        <form action="{{route('login-check')}}" method="POST" role="form text-left">
                            @csrf
                            
                            <!-- Username Selection -->
                            <div class="mb-3">
                                <label for="username">Username</label>
                                <div class="@error('username')border border-danger rounded-3 @enderror">
                                    <input id="username" type="text" name="username" class="form-control" 
                                    placeholder="Username" aria-label="Username" aria-describedby="username-addon">
                                </div>
                                @error('username') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <!-- Password Selection -->
                            <div class="mb-3">
                                <label for="password">Password</label>
                                <div class="@error('password')border border-danger rounded-3 @enderror">
                                    <input id="password" type="password" name="password" class="form-control"
                                     placeholder="Password" aria-label="Password" aria-describedby="password-addon">
                                </div>
                                @error('password') <div class="text-danger">{{ $message }}</div> @enderror
                            </div>

                            <!-- Remember Me -->
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" name="remember" id="rememberMe">
                                <label class="form-check-label" for="rememberMe">Remember me</label>
                            </div>

                            <!-- Submit Button -->
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary w-100 mt-4 mb-0">Sign in</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
