<?php

namespace App\Http\Controllers;

use App\Models\College;
use App\Models\CollegeConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CollegeConfigController extends Controller
{
    public function getCollegeData(Request $request)
    {
        $data = CollegeConfig::select('college_id', 'college_name', 'config_key', 'config_value')
            ->get()
            ->groupBy('college_id');

        $response = [];
        $counter = 1;

        foreach ($data as $college_id => $configs) {
            $collegeData = [
                'DT_RowIndex' => $counter++,
                'college_name' => $configs->first()->college_name,
                'config_1' => $this->getConfigValue($configs, 'config_1'),
                'config_2' => $this->getConfigValue($configs, 'config_2'),
                'config_3' => $this->getConfigValue($configs, 'config_3'),
                'config_4' => $this->getConfigValue($configs, 'config_4'),
                'config_5' => $this->getConfigValue($configs, 'config_5'),
                'config_6' => $this->getConfigValue($configs, 'config_6'),
                'config_7' => $this->getConfigValue($configs, 'config_7'),
                'config_8' => $this->getConfigValue($configs, 'config_8'),
                'config_9' => $this->getConfigValue($configs, 'config_9'),
                'config_10' => $this->getConfigValue($configs, 'config_10'),
                'config_11' => $this->getConfigValue($configs, 'config_11'),
                'config_12' => $this->getConfigValue($configs, 'config_12'),
                'action' => '<a href="#" ><i class="fa fa-edit"></i></a> <a href="#" ><i class="fa fa-trash"></i></a>'
            ];

            $response[] = $collegeData;
        }


        return response()->json([
            'draw' => $request->draw,
            'recordsTotal' => count($response),
            'recordsFiltered' => count($response),
            'data' => $response,
        ]);
    }

    private function getConfigValue($configs, $configKey)
    {
        $config = $configs->where('config_key', $configKey)->first();
        return $config ? $config->config_value : null;
    }
    public function store(Request $request)
    {
        $request->validate([
            'college_name' => 'required|string|max:255',
        ]);
        $logoName = null;
        if ($request->hasFile('logo') && $request->file('logo')->isValid()) {
            $originalName = $request->logo->getClientOriginalName();
            $logoName = time() . '-' . $originalName;
            $request->logo->move(public_path('logos'), $logoName);
        }
        $college = College::Create([
            'college_name' => $request->input('college_name'),
            'address' => $request->input('address'),
            'email' => $request->input('email'),
            'mobile' => $request->input('contact'),
            'logo' => $logoName,
        ]);


        $collegeName = $request->input('college_name');
        $configs = $request->except(['_token', 'college_name', 'address', 'email', 'contact', 'logo']);

        foreach ($configs as $key => $value) {
            CollegeConfig::create([
                'college_name' => $collegeName,
                'college_id' => $college->id,
                'config_key' => $key,
                'config_value' => $value,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
        return redirect()->route('college-config-add')->with('success', 'College Configuration saved successfully!');
    }
}
