<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Protection;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Illuminate\Support\Facades\DB;

class CollegeConfigExport implements FromCollection, WithEvents
{

    protected $college_id;

    public function __construct($college_id)
    {
        $this->college_id = $college_id;
    }
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $configs = DB::table('college_config')->where('college_id', $this->college_id)
                                ->pluck('config_value', 'config_key');

        return collect([$configs->toArray()]);
    }

    public function headings(): array
    {
        $config_values =  DB::table('college_config')->where('college_id', $this->college_id)
                                     ->pluck('config_value')
                                     ->toArray();

        return $config_values;
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $sheet = $event->sheet->getDelegate();  // Get the PhpSpreadsheet sheet

                // Unlock the heading row (assuming the first row is the header)
                $sheet->getStyle('1:1')->getProtection()->setLocked(Protection::PROTECTION_PROTECTED);
                
            }
        ];
    }
}
