@extends('layouts.layoutapp')

@section('content')
    <style>
        .form-control {
            padding-left: 10px !important;
        }

        .error-highlight {
            background-color: #fff3f3 !important;
            border-left: 3px solid #dc3545 !important;
        }

        .row-error {
            font-size: 0.8rem;
            margin-top: 3px;
        }
    </style>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <form class="form-submit" enctype="multipart/form-data">
                    @csrf
                    <div class="card mb-4 mx-4">
                        <div class="card-header pb-0">
                            <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                                <div>
                                    <h5 class="mb-0">Add New Product's</h5>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">

                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label>Supplier:</label>
                                    <select name="supplier_id" class="form-select select2 supplier_id" required>
                                        <option value="" selected disabled>Select Supplier</option>
                                        @foreach ($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>{{ $supplier->supplier_name }}</option>
                                        @endforeach
                                    </select>
                                    @error('supplier_id') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label>Payment Date:</label>
                                    <input type="date" name="payment_date" id="payment_date" class="form-control"
                                        value="{{ date('Y-m-d') }}">
                                    @error('payment_date') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>

                            </div>

                            <div class="product-row card mb-3 position-relative p-3 shadow-lg p-3 mb-5 bg-body-tertiary">
                                <div class="text-end">
                                    <button class="btn btn-primary btn-sm add-row" type="button">+ Add</button>
                                </div>
                                <div class="row g-3">
                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Category</label>
                                        <select class="form-select form-select-sm category_id">
                                            <option value="">Select Category</option>
                                            @foreach ($categories as $item)
                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                        <small class="text-danger error-message" id="error-category_id"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Product Name</label>
                                        <input type="text" class="form-control name form-control-sm"
                                            placeholder="Product Name">
                                        <small class="text-danger error-message" id="error-name"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Native Name</label>
                                        <input type="text" class="form-control nativename form-control-sm"
                                            placeholder="Native Name">
                                        <small class="text-danger error-message" id="error-name"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Product Code</label>
                                        <input type="text" class="form-control productCode form-control-sm"
                                            placeholder="Product Code">
                                        <small class="text-danger error-message" id="error-productCode"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Quantity</label>
                                        <input type="number" class="form-control qty form-control-sm" placeholder="Qty"
                                            step="0.01">
                                        <small class="text-danger error-message" id="error-qty"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Buying Price</label>
                                        <input type="number" class="form-control margin_price form-control-sm"
                                            placeholder="B.P">
                                        <small class="text-danger error-message" id="error-margin_price"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Selling Price</label>
                                        <input type="number" class="form-control unit_price form-control-sm"
                                            placeholder="S.P">
                                        <small class="text-danger error-message" id="error-unit_price"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">HSN Code</label>
                                        <input type="text" class="form-control hsnCode form-control-sm"
                                            placeholder="HSN Code">
                                        <small class="text-danger error-message" id="error-hsnCode"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Description</label>
                                        <input type="text" class="form-control description form-control-sm"
                                            placeholder="Description">
                                        <small class="text-danger error-message" id="error-description"></small>
                                    </div>
                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Total Amount</label>
                                        <input type="number" class="form-control total_amount form-control-sm" readonly
                                            placeholder="Total Amount">
                                        <small class="text-danger error-message" id="error-total_amount"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Product Type</label>
                                        <select class="form-select product_type form-select-sm">
                                            <option value="">Select Product Type</option>
                                            @foreach ($product_type as $item)
                                                <option value="{{$item->id}}" {{$item->name == 'Ready Product' ? 'selected' : ''}}>{{$item->name}} </option>
                                            @endforeach
                                        </select>
                                        <small class="text-danger error-message" id="error-product_type"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Payment Type</label>
                                        <select class="form-select payment_type form-select-sm">
                                            <option value="">Select Payment Type</option>
                                            @foreach ($payment_type as $item)
                                                <option value="{{$item->name}}">{{$item->name}} </option>
                                            @endforeach
                                        </select>
                                        <small class="text-danger error-message" id="error-payment_type"></small>
                                    </div>

                                    <div class="col-md-2">
                                        <label class="form-label mb-0">Paid Amount</label>
                                        <input type="number" class="form-control paid_amount form-control-sm"
                                            placeholder="Paid Amount">
                                        <small class="text-danger error-message" id="error-paid_amount"></small>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive product-table">
                                <table class="table table-bordered table-striped text-xxs">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Category</th>
                                            <th class="text-center">Name</th>
                                            <th class="text-center">Code</th>
                                            <th class="text-center">Qty</th>
                                            <th class="text-center">B.P</th>
                                            <th class="text-center">S.P</th>
                                            <th class="text-center">HSN</th>
                                            {{-- <th class="text-center">Description</th> --}}
                                            <th class="text-center">Total Amount</th>
                                            <th class="text-center">Product Type</th>
                                            <th class="text-center">Payment Type</th>
                                            <th class="text-center">Paid Amount</th>
                                            <th class="text-center"></th>
                                        </tr>
                                    </thead>
                                    <tbody class="product-body">
                                        <tr class="first-row">
                                            <td class="text-center" colspan="12">Enter the Product details then Add... </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary btn-sm ms-2 saveProduct">Save
                                    Product's</button>
                                <a href="{{ route('product-index') }}" class="btn btn-secondary btn-sm ms-2">Cancel</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let products = [];

        $('.qty').on('input', function () {
            calculateRowTotal();
        });
        $('.margin_price').on('input', function () {
            calculateRowTotal();
        });

        $(document).ready(function () {
            $('.add-row').on('click', function () {
                const isEditMode = $(this).data('edit-mode');
                const category_id = $('.category_id').val();
                const category_text = $('.category_id option:selected').text();
                const name = $('.name').val();
                const nativeName = $('.nativename').val();
                const productCode = $('.productCode').val();
                const hsnCode = $('.hsnCode').val();
                const qty = parseFloat($('.qty').val()) || 0;
                const unit_price = parseFloat($('.unit_price').val()) || 0;
                const margin_price = parseFloat($('.margin_price').val()) || 0;
                const description = $('.description').val();
                const total_amount = parseFloat($('.total_amount').val()) || 0;
                const product_type = $('.product_type').val();
                const product_type_text = $('.product_type option:selected').text();
                const payment_type = $('.payment_type').val().toLowerCase();
                const payment_type_text = payment_type ? $('.payment_type option:selected').text() : '-';
                const paid_amount = parseFloat($('.paid_amount').val()) || 0;

                if (products.some(p => p.productCode === productCode)) {
                    showInlineError('.productCode', 'This product code already exists in your current list');
                    return;
                }

                clearValidationErrors();

                let hasError = false;

                if (!category_id) {
                    showInlineError('.category_id', 'Category is required.');
                    hasError = true;
                }
                if (!name) {
                    showInlineError('.name', 'Name is required.');
                    hasError = true;
                }
                if (!productCode) {
                    showInlineError('.productCode', 'Product Code is required.');
                    hasError = true;
                }
                if (!qty || qty <= 0) {
                    showInlineError('.qty', 'Valid quantity is required.');
                    hasError = true;
                }
                if (!unit_price) {
                    showInlineError('.unit_price', 'Selling Price is required.');
                    hasError = true;
                }
                if (!margin_price) {
                    showInlineError('.margin_price', 'Buying Price is required.');
                    hasError = true;
                }
                if (!product_type) {
                    showInlineError('.product_type', 'Product Type is required.');
                    hasError = true;
                }

                if (paid_amount) {
                    if (!payment_type) {
                        showInlineError('.payment_type', 'Payment Type is required.');
                        hasError = true;
                    }

                }

                if (hasError) return;

                const product = { category_id, category_text, name, nativeName, productCode, hsnCode, qty, unit_price, margin_price, description, total_amount, product_type, product_type_text, payment_type, payment_type_text, paid_amount };

                if (isEditMode) {
                    products.push(product);
                    $(this).text('+ Add').data('edit-mode', false);
                } else {
                    products.push(product);
                }

                updateProductTable();

                $('.category_id, .name, .nativename, .productCode, .hsnCode ,.qty, .unit_price, .margin_price, .description, .product_type, .payment_type, .paid_amount').val('');
                $('.total_amount').val('0');
            });

            $('.saveProduct').on('click', function () {
                hasError = false;
                clearValidationErrors();

                // Validate products
                if (products.length === 0) {
                    showInlineError('.product-body', 'Please add at least one product');
                    hasError = true;
                }

                // Validate supplier
                let supplierId = $('.supplier_id').val();
                if (!supplierId) {
                    showInlineError('.supplier_id', 'Supplier is required.');
                    hasError = true;
                }

                if (hasError) {
                    return false;
                }
                const formData = new FormData($('.form-submit')[0]);

                $.ajax({
                    url: "{{ route('product-store') }}",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (data) {

                        if (data.status === 'success') {
                            Swal.fire({
                                title: 'Success!',
                                text: data.message,
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                products = [];
                                updateProductTable();
                                $('.form-submit')[0].reset();
                                $('.select2').val('').trigger('change');
                            });
                        }
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            const { errors } = xhr.responseJSON;

                            $('.error-highlight').removeClass('error-highlight');
                            $('.row-error').remove();

                            if (errors.form) {
                                Object.entries(errors.form).forEach(([field, message]) => {
                                    $(`.${field}`).addClass('is-invalid');
                                    $(`#error-${field}`).text(message);
                                });
                            }

                            if (errors.rows) {
                                Object.entries(errors.rows).forEach(([rowIndex, fields]) => {
                                    const $row = $(`.product-body tr[data-index="${rowIndex}"]`);

                                    $row.addClass('error-highlight');

                                    Object.entries(fields).forEach(([field, message]) => {
                                        $row.find(`td[data-field="${field}"]`)
                                            .append(`<div class="row-error text-danger small">${message}</div>`);
                                    });
                                });

                                $('html, body').animate({
                                    scrollTop: $('.error-highlight').first().offset().top - 100
                                }, 500);
                            }
                        }
                    }
                });
            });

            $(document).on('click', '.remove-product', function () {
                const index = $(this).closest('tr').data('index');

                if (index !== undefined && products[index]) {
                    products.splice(index, 1);
                }

                $(this).closest('tr').remove();

                $('.product-body tr[data-index]').each(function (newIndex) {
                    $(this).attr('data-index', newIndex);
                });

                if ($('.product-body tr').length === 0) {
                    $('.product-body').append(`
                                                                        <tr class="first-row">
                                                                            <td class="text-center" colspan="12">Enter the Product details then Add...</td>
                                                                        </tr>
                                                                    `);
                }

                products = products.map((product, index) => ({ ...product, index }));
            });

            $(document).on('click', '.edit-product', function () {
                const index = $(this).closest('tr').data('index');

                if (index !== undefined && products[index]) {
                    const product = products[index];

                    $('.category_id').val(product.category_id).trigger('change');
                    $('.name').val(product.name);
                    $('.productCode').val(product.productCode);
                    $('.hsnCode').val(product.hsnCode);
                    $('.qty').val(product.qty);
                    $('.unit_price').val(product.unit_price);
                    $('.margin_price').val(product.margin_price);
                    $('.description').val(product.description);
                    $('.total_amount').val(product.total_amount);
                    $('.product_type').val(product.product_type).trigger('change');
                    $('.payment_type').val(product.payment_type).trigger('change');
                    $('.paid_amount').val(product.paid_amount);

                    products.splice(index, 1);

                    $(this).closest('tr').remove();

                    products = products.map((product, newIndex) => ({ ...product, index: newIndex }));
                    updateProductTable();

                    $('html, body').animate({
                        scrollTop: $('.product-row').offset().top - 20
                    }, 300);

                    $('.add-row').text('Update Product').data('edit-mode', true);
                }
            });
        });

        function updateProductTable() {
            const $tbody = $('.product-body');
            $tbody.empty();

            if (products.length === 0) {
                $tbody.append(`
                                                                        <tr class="first-row">
                                                                            <td class="text-center" colspan="12">Enter the Product details then Add...</td>
                                                                        </tr>
                                                                    `);
                return;
            }

            products.forEach((product, index) => {
                $tbody.append(`
                                                <tr data-index="${index}">
                                                    <td class="text-center" data-field="category_id">
                                                        <input type="hidden" name = product[${index}][category_id] value="${product.category_id}"/>
                                                        ${product.category_text}
                                                    </td>
                                                    <td class="text-center" data-field="name">
                                                        <input type="hidden" name = product[${index}][name] value="${product.name}"/>                                                        
                                                        <input type="hidden" name = product[${index}][native_name] value="${product.nativeName}"/>                                                        
                                                        ${product.name}
                                                    </td>
                                                    <td class="text-center" data-field="productCode">
                                                        <input type="hidden" name = product[${index}][productCode] value="${product.productCode}"/>
                                                        ${product.productCode}
                                                    </td>
                                                    <td class="text-center" data-field="qty">
                                                        <input type="hidden" name = product[${index}][qty] value="${product.qty}"/>                                                        
                                                        ${product.qty}
                                                    </td>                                               
                                                    <td class="text-center" data-field="margin_price">
                                                        <input type="hidden" name = product[${index}][margin_price] value="${product.margin_price || ''}"/>      
                                                        <input type="hidden" name = product[${index}][description] value="${product.description || ''}"/>                                                        
                                                        ${product.margin_price}
                                                    </td> 
                                                     <td class="text-center" data-field="unit_price">
                                                        <input type="hidden" name = product[${index}][unit_price] value="${product.unit_price}"/>
                                                        ${product.unit_price}
                                                    </td>  
                                                        <td class="text-center" data-field="hsnCode">
                                                        <input type="hidden" name = product[${index}][hsnCode] value="${product.hsnCode || '-'}"/>                                                        
                                                        ${product.hsnCode || '-'}
                                                    </td>                                                                                    
                                                    <td class="text-center" data-field="total_amount">
                                                        <input type="hidden" name = product[${index}][total_amount] value="${product.total_amount || ''}"/>                                                        
                                                        ${product.total_amount}
                                                    </td>
                                                    <td class="text-center" data-field="product_type">
                                                        <input type="hidden" name = product[${index}][product_type] value="${product.product_type || ''}"/>                                                        
                                                        ${product.product_type_text}</td>
                                                    <td class="text-center" data-field="payment_type">
                                                        <input type="hidden" name = product[${index}][payment_type] value="${product.payment_type || ''}"/>                                                                                                                
                                                        ${product.payment_type_text}</td>
                                                    <td class="text-center" data-field="paid_amount">
                                                        <input type="hidden" name = product[${index}][paid_amount] value="${product.paid_amount || ''}"/>                                                                                                                
                                                        ${product.paid_amount || '0'}</td>
                                                    <td class="text-center">
                                                        <a href="javascript:void(0)" class="text-success edit-product me-2" data-index="${index}">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <a href="javascript:void(0)" class="text-danger remove-product" data-index="${index}">
                                                            <i class="fas fa-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            `);
            });
        }

        function showInlineError(selector, message) {
            const input = $(selector);
            input.addClass('is-invalid');

            input.closest('.col-md-2,.col-md-4,.product-table').find('.error-message').remove();

            const errorEl = $(`<small class="text-danger error-message">${message}</small>`);

            if (selector === '.product-body') {
                $('.product-table').before(errorEl);
            }
            else if (input.hasClass('select2')) {
                input.closest('.col-md-2,.col-md-4').append(errorEl);
            }
            else {
                const columnParent = input.closest('[class*="col-md-"]');
                if (columnParent.length) {
                    columnParent.append(errorEl);
                } else {
                    input.after(errorEl);
                }
            }
        }
        function clearValidationErrors() {
            $('.error-message').remove();
            $('.is-invalid').removeClass('is-invalid');
            $('.product-body tr').removeClass('border border-danger');
            $('.product-body tr td div.text-danger').remove();
        }

        function calculateRowTotal() {
            const qty = parseFloat($('.qty').val()) || 0;
            const marginPrice = parseFloat($('.margin_price').val()) || 0;
            const totalAmount = qty * marginPrice;

            $('.total_amount').val(totalAmount.toFixed(2));
        }

    </script>
@endpush