@extends('layouts.layoutapp')

@section('content')
    <style>
        #sidenav-main,
        #navbarBlur,
        .footer {
            display: none !important;
        }

        .main-content {
            margin-left: 0 !important;
            background-color: white;
            padding: 20px;
        }

        h1,
        h5,
        h3 {
            margin-top: 20px;
        }

        p {
            margin-bottom: 15px;
            line-height: 1.6;
        }
    </style>

    <div class="main-content">
        <div class="content-container">
            <div class="row">
                <div class="col-12">
                    <h3>Billing Privacy Policy</h3>

                    <h5>1. Introduction</h5>
                    <p>
                        Your privacy is important to us. This Billing Privacy Policy explains how we collect, use, store,
                        and protect your personal information related to billing, payments, and financial transactions when
                        you use our services.
                    </p>

                    <h5>2. Information We Collect</h5>
                    <p>We may collect the following types of information when you interact with our billing system:</p>
                    <ul>
                        <li>Personal details: Name, address, contact number, email address.</li>
                        <li>Billing information: Invoice details, payment amounts, discounts, and tax details.</li>
                        <li>Payment information: Payment method, transaction IDs, and payment
                            confirmation.</li>
                    </ul>

                    <h5>3. How We Use Your Information</h5>
                    <p>We use the information collected for the following purposes:</p>
                    <ul>
                        <li>To process payments and generate accurate invoices.</li>
                        <li>To calculate taxes, discounts, and net amounts for billing purposes.</li>
                        <li>To maintain accurate financial records for auditing and reporting.</li>
                        <li>To communicate billing details and notifications related to your account.</li>
                        <li>To comply with legal and regulatory requirements.</li>
                    </ul>

                    <h5>4. Sharing of Information</h5>
                    <p>We do not sell or rent your personal billing information to third parties. Information may be shared
                        in the following cases:</p>
                    <ul>
                        <li>With authorized service providers assisting in payment processing.</li>
                        <li>For legal compliance, such as responding to lawful requests or regulations.</li>
                        <li>With auditors or financial institutions as required for auditing purposes.</li>
                    </ul>

                    <h5>5. Data Security</h5>
                    <p>We implement appropriate administrative, technical, and physical measures to safeguard your billing
                        information from unauthorized access, disclosure, alteration, or destruction. Examples include:</p>
                    <ul>
                        <li>Encrypted storage of sensitive payment information.</li>
                        <li>Secure transmission of payment data via HTTPS.</li>
                        <li>Restricted access to authorized personnel only.</li>
                    </ul>

                    <h5>6. Data Retention</h5>
                    <p>Billing and financial information is retained for as long as necessary to fulfill the purposes
                        outlined in this policy and to comply with legal obligations.</p>

                    <h5>7. Your Rights</h5>
                    <p>You have the right to:</p>
                    <ul>
                        <li>Access the billing information we hold about you.</li>
                        <li>Request corrections or updates to your billing data.</li>
                        <li>Request deletion of personal data where legally applicable.</li>
                        <li>Withdraw consent for processing of your information (where applicable).</li>
                    </ul>

                    <h5>8. Changes to This Policy</h5>
                    <p>We may update this Billing Privacy Policy from time to time. The updated policy will be effective
                        immediately upon posting. We encourage you to review this page periodically.</p>
                </div>
            </div>
        </div>
    </div>
@endsection