

<?php $__env->startSection('content'); ?>
    <style>
        .form-control {
            padding-left: 10px !important;
        }

        .error-highlight {
            background-color: #fff3f3 !important;
            border-left: 3px solid #dc3545 !important;
        }

        .row-error {
            font-size: 0.8rem;
            margin-top: 3px;
        }

        .product-image-preview {
            width: 50px;
            height: 50px;
            object-fit: cover;
        }
    </style>
    <div class="row">
        <div class="col-12">
            <form class="form-submit" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card me-2">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                            <div>
                                <h5 class="mb-0">Add New Product</h5>
                            </div>
                            <div class="text-end">
                                <button class="btn btn-primary btn-sm add-row" type="button">+ Add</button>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <div class="product-row mb-3 position-relative p-3 p-3 mb-5 bg-body-tertiary">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <label class="form-label mb-0">Category</label>
                                    <select class="form-select form-select-sm category_id">
                                        <option value="">Select Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <small class="text-danger error-message" id="error-category_id"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">Product Name</label>
                                    <input type="text" class="form-control name form-control-sm" placeholder="Product Name">
                                    <small class="text-danger error-message" id="error-name"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">Native Name</label>
                                    <input type="text" class="form-control nativename form-control-sm"
                                        placeholder="Native Name">
                                    <small class="text-danger error-message" id="error-name"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">Product Code</label>
                                    <input type="text" class="form-control productCode form-control-sm"
                                        placeholder="Product Code">
                                    <small class="text-danger error-message" id="error-productCode"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">Buying Price</label>
                                    <input type="number" class="form-control margin_price form-control-sm"
                                        placeholder="B.P">
                                    <small class="text-danger error-message" id="error-margin_price"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">Selling Price</label>
                                    <input type="number" class="form-control unit_price form-control-sm" placeholder="S.P">
                                    <small class="text-danger error-message" id="error-unit_price"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">HSN Code</label>
                                    <input type="text" class="form-control hsnCode form-control-sm" placeholder="HSN Code">
                                    <small class="text-danger error-message" id="error-hsnCode"></small>
                                </div>

                                <div class="col-md-3">
                                    <label class="form-label mb-0">Image</label>
                                    <input type="file" class="form-control form-control-sm product_image" accept="image/*">
                                    <small class="text-danger error-message" id="error-product_image"></small>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label mb-0">Product Type</label>
                                    <select class="form-select product_type form-select-sm">
                                        <option value="">Select Product Type</option>
                                        <?php $__currentLoopData = $product_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>" <?php echo e($item->name == 'Ready Product' ? 'selected' : ''); ?>>
                                                <?php echo e($item->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <small class="text-danger error-message" id="error-product_type"></small>
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label mb-0">Description</label>
                                    <input type="text" class="form-control description form-control-sm"
                                        placeholder="Description">
                                    <small class="text-danger error-message" id="error-description"></small>
                                </div>

                            </div>
                        </div>

                        <div class="table-responsive product-table">
                            <table class="table table-bordered table-striped text-xxs">
                                <thead>
                                    <tr>
                                        <th class="text-center">Category</th>
                                        <th class="text-center">Name</th>
                                        <th class="text-center">Code</th>
                                        <th class="text-center">B.P</th>
                                        <th class="text-center">S.P</th>
                                        <th class="text-center">HSN</th>
                                        <th class="text-center">Description</th>
                                        <th class="text-center">Product Type</th>
                                        <th class="text-center">Image</th>
                                        <th class="text-center"></th>
                                    </tr>
                                </thead>
                                <tbody class="product-body">
                                    <tr class="first-row">
                                        <td class="text-center" colspan="10">Enter the Product details then Add...</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-primary btn-sm ms-2 saveProduct">Save Product</button>
                            <a href="<?php echo e(route('product-index')); ?>" class="btn btn-secondary btn-sm ms-2">Cancel</a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let products = [];

        $(document).ready(function () {
            $('.add-row').on('click', function () {
                const isEditMode = $(this).data('edit-mode');
                const category_id = $('.category_id').val();
                const category_text = $('.category_id option:selected').text();
                const name = $('.name').val();
                const nativeName = $('.nativename').val();
                const productCode = $('.productCode').val();
                const hsnCode = $('.hsnCode').val();
                const unit_price = parseFloat($('.unit_price').val()) || 0;
                const margin_price = parseFloat($('.margin_price').val()) || 0;
                const description = $('.description').val();
                const product_type = $('.product_type').val();
                const product_type_text = $('.product_type option:selected').text();
                const imageFile = $('.product_image')[0].files[0] || null;

                if (products.some(p => p.productCode === productCode)) {
                    showInlineError('.productCode', 'This product code already exists in your current list');
                    return;
                }

                clearValidationErrors();

                let hasError = false;
                if (!category_id) { showInlineError('.category_id', 'Category is required.'); hasError = true; }
                if (!name) { showInlineError('.name', 'Name is required.'); hasError = true; }
                // if (!productCode) { showInlineError('.productCode', 'Product Code is required.'); hasError = true; }
                if (!unit_price) { showInlineError('.unit_price', 'Selling Price is required.'); hasError = true; }
                if (!margin_price) { showInlineError('.margin_price', 'Buying Price is required.'); hasError = true; }
                if (!product_type) { showInlineError('.product_type', 'Product Type is required.'); hasError = true; }

                if (hasError) return;

                const product = { category_id, category_text, name, nativeName, productCode, hsnCode, unit_price, margin_price, description, product_type, product_type_text, imageFile };

                if (isEditMode) { products.push(product); $(this).text('+ Add').data('edit-mode', false); }
                else { products.push(product); }

                updateProductTable();
                $('.category_id, .name, .nativename, .productCode, .hsnCode ,.unit_price, .margin_price, .description, .product_type, .product_image').val('');
            });

            $('.saveProduct').on('click', function () {
                clearValidationErrors();
                if (products.length === 0) {
                    showInlineError('.product-body', 'Please add at least one product');
                    return false;
                }

                const formData = new FormData($('.form-submit')[0]);
                products.forEach((product, i) => {
                    if (product.imageFile) formData.append(`product[${i}][product_image]`, product.imageFile);
                });

                $.ajax({
                    url: "<?php echo e(route('product-store')); ?>",
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                //    headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                    success: function (data) {
                        if (data.status === 'success') {
                            Swal.fire({
                                title: 'Success!',
                                text: data.message,
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then(() => {
                                products = [];
                                updateProductTable();
                                $('.form-submit')[0].reset();
                                $('.select2').val('').trigger('change');
                            });
                        } else if (data.status === 'error') {
                            let errorText = data.message;
                            if (data.errors) {
                                Object.values(data.errors).forEach(errArr => {
                                    errorText += '\n' + errArr.join(', ');
                                });
                            }

                            Swal.fire({
                                title: 'Error!',
                                text: errorText,
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                        }
                    },
                    error: function (xhr) {
                        let errorMsg = 'Something went wrong!';
                        if (xhr.responseJSON && xhr.responseJSON.errors) {
                            errorMsg = Object.values(xhr.responseJSON.errors).flat().join('\n');
                        }
                        Swal.fire({
                            title: 'Error!',
                            text: errorMsg,
                            icon: 'error',
                            confirmButtonText: 'OK'
                        });
                    }
                });

            });

            $(document).on('click', '.remove-product', function () {
                const index = $(this).closest('tr').data('index');
                if (index !== undefined && products[index]) { products.splice(index, 1); }
                $(this).closest('tr').remove();
                if ($('.product-body tr').length === 0) {
                    $('.product-body').append(`<tr class="first-row"><td class="text-center" colspan="10">Enter the Product details then Add...</td></tr>`);
                }
                products = products.map((product, index) => ({ ...product, index }));
            });

            $(document).on('click', '.edit-product', function () {
                const index = $(this).closest('tr').data('index');
                if (index !== undefined && products[index]) {
                    const product = products[index];
                    $('.category_id').val(product.category_id).trigger('change');
                    $('.name').val(product.name);
                    $('.productCode').val(product.productCode);
                    $('.hsnCode').val(product.hsnCode);
                    $('.unit_price').val(product.unit_price);
                    $('.margin_price').val(product.margin_price);
                    $('.description').val(product.description);
                    $('.product_type').val(product.product_type).trigger('change');

                    products.splice(index, 1);
                    $(this).closest('tr').remove();
                    products = products.map((product, newIndex) => ({ ...product, index: newIndex }));
                    updateProductTable();

                    $('.add-row').text('Update Product').data('edit-mode', true);
                }
            });
        });

        function updateProductTable() {
            const $tbody = $('.product-body');
            $tbody.empty();

            if (products.length === 0) {
                $tbody.append(`<tr class="first-row"><td class="text-center" colspan="10">Enter the Product details then Add...</td></tr>`);
                return;
            }

            products.forEach((product, index) => {
                let imagePreview = product.imageFile ? `<img src="${URL.createObjectURL(product.imageFile)}" class="product-image-preview">` : '-';
                $tbody.append(`
                                            <tr data-index="${index}">
                                                <td class="text-center" data-field="category_id">
                                                    <input type="hidden" name="product[${index}][category_id]" value="${product.category_id}"/>
                                                    ${product.category_text}
                                                </td>
                                                <td class="text-center" data-field="name">
                                                    <input type="hidden" name="product[${index}][name]" value="${product.name}"/>
                                                    <input type="hidden" name="product[${index}][native_name]" value="${product.nativeName}"/>
                                                    ${product.name}
                                                </td>
                                                <td class="text-center" data-field="productCode">
                                                    <input type="hidden" name="product[${index}][productCode]" value="${product.productCode}"/>
                                                    ${product.productCode}
                                                </td>
                                                <td class="text-center" data-field="margin_price">
                                                    <input type="hidden" name="product[${index}][margin_price]" value="${product.margin_price}"/>
                                                    ${product.margin_price}
                                                </td>
                                                <td class="text-center" data-field="unit_price">
                                                    <input type="hidden" name="product[${index}][unit_price]" value="${product.unit_price}"/>
                                                    ${product.unit_price}
                                                </td>
                                                <td class="text-center" data-field="hsnCode">
                                                    <input type="hidden" name="product[${index}][hsnCode]" value="${product.hsnCode}"/>
                                                    ${product.hsnCode || '-'}
                                                </td>
                                                <td class="text-center" data-field="description">
                                                    <input type="hidden" name="product[${index}][description]" value="${product.description}"/>
                                                    ${product.description || '-'}
                                                </td>
                                                <td class="text-center" data-field="product_type">
                                                    <input type="hidden" name="product[${index}][product_type]" value="${product.product_type}"/>
                                                    ${product.product_type_text}
                                                </td>
                                                <td class="text-center" data-field="image">
                                                    ${imagePreview}
                                                </td>
                                                <td class="text-center">
                                                    <a href="javascript:void(0)" class="text-success edit-product me-2" data-index="${index}"><i class="fas fa-edit"></i></a>
                                                    <a href="javascript:void(0)" class="text-danger remove-product" data-index="${index}"><i class="fas fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        `);
            });
        }

        function showInlineError(selector, message) {
            const input = $(selector);
            input.addClass('is-invalid');
            input.closest('.col-md-3,.product-table').find('.error-message').remove();
            const errorEl = $(`<small class="text-danger error-message">${message}</small>`);
            if (selector === '.product-body') { $('.product-table').before(errorEl); }
            else { input.closest('[class*="col-md-"]').append(errorEl); }
        }

        function clearValidationErrors() {
            $('.error-message').remove();
            $('.is-invalid').removeClass('is-invalid');
            $('.product-body tr').removeClass('border border-danger');
            $('.product-body tr td div.text-danger').remove();
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/products/add.blade.php ENDPATH**/ ?>