<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

use Illuminate\Contracts\Auth\CanResetPassword;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;


class User extends Authenticatable
{
    use HasFactory, Notifiable, HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */

    protected $guarded = [];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // In User.php model
    /**
     * Get all companies the user has access to.
     */
    public function companies()
    {
        return $this->belongsToMany(CompanyModel::class, 'company_user', 'user_id', 'company_id');
    }

    /**
     * Get all branches the user has access to.
     */
    public function branches()
    {
        return $this->belongsToMany(BranchModel::class, 'branch_user', 'user_id', 'branch_id');
    }

    public function rights()
    {
        return $this->belongsTo(RightsModel::class, 'rights_id');
    }
    public function client()
    {
        return $this->hasOne(ClientModel::class, 'user_id', 'id');
    }
    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id', 'id');
    }

}
