<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            font-size: 12px;
        }

        .header {
            width: 99.7%;
            margin-bottom: 0px;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
        }

        .company-details {
            text-align: center;
        }

        .address {
            text-align: center;
            font-size: 15px;
            font-weight: bold;

        }

        .mail {
            text-align: center;
            font-size: 15px;
            font-weight: bold;
        }

        .invoice-details {
            width: 100%;
            margin-bottom: 0px;
            margin-top: 0px;
        }

        .info-table {
            width: 100%;
            border-top: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            border-collapse: collapse;
            table-layout: fixed;
        }

        .info-table td {
            width: 50%;
            padding: 8px;
            vertical-align: top;
            border-right: 1px solid #000;
        }

        .client-details {
            text-align: left;
        }

        .invoice-info {
            text-align: left;
        }

        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 0px;
            border-bottom: 1px solid #000 !important;
        }

        .product-table th,
        .product-table td {
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            padding: 8px;
            text-align: left;
        }

        .product-table tbody tr:last-child td {
            border-bottom: 1px solid #000 !important;
            border-bottom-width: 1px !important;
        }

        .product-table th {
            background-color: #f2f2f2;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }

        .footer {

            border-bottom: 1px solid #000;
            border-left: 1px solid #000;
            border-right: 1px solid #000;
            text-align: right;
            padding-right: 10px;
        }

        .footer-table td {
            /* border-right: 1px solid #000; */
        }

        .page-break {
            page-break-before: always;
        }

        .col-id {
            width: 20px;
        }

        .col-description {
            width: 40%;
        }

        .col-code {
            width: 40px;
        }

        .col-qty {
            width: 40px;
        }

        .col-rate {
            width: 40px;
        }

        .col-gst {
            width: 40px;
        }

        .col-total {
            width: 45px;
        }
    </style>
</head>

<body>
    <div class="header">
        <?php if($type == 'I'): ?>
            <div class="company-details">
                <h3><?php echo e($companyName); ?></h3>
            </div>
            <div class="address">
                <?php echo e($companyAddress); ?>,
            </div>
            <div class="mail">
                Mail -<?php echo e($email); ?>

            </div>
        <?php elseif($type == 'Q'): ?>
            <div class="company-details">
                <h3><?php echo e($companyName ?? ''); ?></h3>
            </div>
            <div class="address">
                Products Quotation
            </div>
            <div class="mail">
                Contact No: <?php echo e($contact_no ?? ''); ?>,
            </div>
        <?php endif; ?>
    </div>
    <div class="invoice-details">
        <table class="info-table">
            <?php if($type == 'I'): ?>
                <tr>
                    <td class="client-details text-start">
                        <strong>GST No -</strong>
                        <?php echo e($gst_no ?? ''); ?><br>
                    </td>
                    <td class="invoice-info">
                        <strong>Contact No:</strong> <?php echo e($contact_no ?? ''); ?><br>
                    </td>
                </tr>
            <?php endif; ?>
        </table>
    </div>
    <div class="invoice-details">
        <table class="info-table">
            <tr>
                <td class="client-details text-start">
                    <strong>To:</strong><?php echo e($clientName); ?><br>
                    <strong>Address:</strong> <?php echo e($clientAddress); ?>

                </td>
                <td class="invoice-info">
                    <?php if($type == 'I'): ?>
                        <strong>Payment Terms:</strong> <?php echo e($payment_terms); ?><br>
                        <strong>Bill No:</strong><?php echo e($invoiceNumber); ?> <br>
                        <strong>Date:</strong> <?php echo e($invoiceDate); ?>

                    <?php endif; ?>
                    <strong>Quote No:</strong><?php echo e($invoiceNumber); ?> <br>
                    <strong>Quote Date:</strong> <?php echo e($invoiceDate); ?>

                </td>
            </tr>
        </table>
    </div>
    <table class="product-table">
        <thead>
            <tr>
                <th class="col-id">S.No</th>
                <th class="col-description">Description</th>
                <th class="col-code">HSN Code</th>
                <th class="col-qty">Qty</th>
                <th class="col-rate">Rate</th>
                <?php if($type == 'I'): ?>
                    <th class="col-gst">GST(%)</th>
                <?php endif; ?>
                <th class="col-total">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $subtotal = 0;
                $pageSubtotal = 0;
                $pageCount = 0;               
            ?>
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $total = $product['quantity'] * $product['unit_price'];
                    $totalWithGst = $total + $product['total_price'];
                    $subtotal += $totalWithGst;
                    $pageSubtotal += $totalWithGst;                            
                ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($product['name']); ?></td>
                    <td><?php echo e($product['code']); ?></td>
                    <td><?php echo e($product['quantity'] . '(' . ($product['uom']) . ')'); ?></td>
                    <td><?php echo e(number_format($product['unit_price'], 2)); ?></td>
                    <?php if($type == 'I'): ?>
                        <td><?php echo e(number_format($product['gst'], 2)); ?></td>
                        <td><?php echo e(number_format($totalWithGst, 2)); ?></td>
                    <?php elseif($type == 'Q'): ?>
                        <td><?php echo e(number_format($total, 2)); ?></td>
                    <?php endif; ?>
                </tr>
                <?php if(($index + 1) % 20 == 0): ?>
                        </tbody>
                    </table>
                    <div class="footer">
                        <table class="footer-table" style="width: 100%;">
                            <tr>
                                <td style="text-align: left;"><strong>Subtotal:</strong> </td>
                                <td style="text-align: right;"><?php echo e(number_format($pageSubtotal, 2)); ?></td>
                            </tr>
                            <tr>
                                <td style="text-align: left;"><strong>Previous Page Subtotal:</strong></td>
                                <td style="text-align: right;"><?php echo e(number_format($subtotal - $pageSubtotal, 2)); ?></td>
                            </tr>
                            <tr>
                                <td style="text-align: left;"><strong>Total:</strong></td>
                                <td style="text-align: right;"> <?php echo e(number_format($subtotal, 2)); ?></td>
                            </tr>
                        </table>
                    </div>
                    <p style="text-align: right;">...Continue</p>
                    <div class="page-break"></div>
                    <div class="header">
                        <div class="company-details">
                            <h3><?php echo e($companyName); ?></h3>
                        </div>
                        <div class="address">
                            <?php echo e($companyAddress); ?>,
                        </div>
                        <div class="mail">
                            Mail -<?php echo e($email); ?>

                        </div>
                    </div>
                    <div class="invoice-details">
                        <table class="info-table">
                            <tr>
                                <td class="client-details text-start">
                                    <strong>GST No -</strong>
                                    <?php echo e($gst_no ?? ''); ?><br>
                                </td>
                                <td class="invoice-info">
                                    <strong>Contact No:</strong> <?php echo e($invoiceNumber ?? ''); ?><br>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="invoice-details">
                        <table class="info-table">
                            <tr>
                                <td class="client-details text-start">
                                    <strong>To:</strong><br>
                                    <?php echo e($clientName); ?><br>
                                    <?php echo e($clientAddress); ?>

                                </td>
                                <td class="invoice-info text-end">
                                    <strong>Payment Terms:</strong> <?php echo e($invoiceDate); ?><br>
                                    <strong>Bill No:</strong><?php echo e($invoiceNumber); ?> <br>
                                    <strong>Date:</strong> <?php echo e($invoiceDate); ?>

                                </td>
                            </tr>
                        </table>
                    </div>
                    <table class="product-table">
                        <thead>
                            <tr>
                                <th class="col-id">S.No</th>
                                <th class="col-description">Description</th>
                                <th class="col-code">HSN Code</th>
                                <th class="col-qty">Qty</th>
                                <th class="col-rate">Rate</th>
                                <?php if($type == 'I'): ?>
                                    <th class="col-gst">GST(%)</th>
                                <?php endif; ?>
                                <th class="col-total">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $pageSubtotal = 0;
                                $pageCount++;
                            ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </tbody>
    </table>
    <div class="footer">
        <table class="footer-table" style="width: 100%; border-collapse: collapse;">
            <tr>
                <td style="text-align:left"> <strong>Subtotal:</strong></td>
                <td style="text-align:right"> <?php echo e(number_format($pageSubtotal, 2)); ?></td>
            </tr>
            <tr>
                <td style="text-align:left"> <strong>Previous Page Subtotal:</strong></td>
                <td style="text-align:right"> <?php echo e(number_format($subtotal - $pageSubtotal, 2)); ?></td>
            </tr>
            <tr>
                <td style="text-align:left"> <strong>Total:</strong></td>
                <td style="text-align:right"> <?php echo e(number_format($subtotal, 2)); ?></td>
            </tr>
            <?php if($type == 'I'): ?>
                <tr>
                    <td style="text-align:left"> <strong>Discount:</strong></td>
                    <td style="text-align:right"> <?php echo e(number_format($discount, 2)); ?></td>
                </tr>
                <tr>
                    <td style="text-align:left"> <strong>GrandTotal:</strong></td>
                    <td style="text-align:right"> <?php echo e(number_format(floor($subtotal - $discount), 2)); ?></td>
                </tr>
                <tr>
                    <td style="text-align:left"> <strong>Total Products Purchased Qty:</strong></td>
                    <td style="text-align:right"> <?php echo e($totalQty ?? ''); ?></td>
                </tr>
            <?php endif; ?>
            <tr>
                <td style="text-align:left" colspan="2"> <strong>Amount In words:</strong>
                    <?php echo e(amountToWords($subtotal - $discount)); ?></td>
            </tr>
            <?php if($type == 'I'): ?>
                <?php if(!empty($terms)): ?>
                    <tr>
                        <td style="text-align:left" colspan="2">
                            <strong>Terms & Conditions:</strong>
                            <?php echo e($terms); ?>

                        </td>
                    </tr>
                <?php endif; ?>
            <?php endif; ?>
        </table>
    </div>
</body>

</html><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/pdf/others.blade.php ENDPATH**/ ?>