

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Invoices</h5>
                            </div>
                            <a href="<?php echo e(route('invoice-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                Invoice</a>
                        </div>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            ID</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoice Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Due Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Amount</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Transactions</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Status</th>
                                             <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Created by</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                                   
                                        <tr>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($invoice->invoice_id); ?></p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->client->user->name ?? ''); ?> <?php echo e($invoice->client->user->last_name ?? ''); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->invoice_date ? \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') : ''); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->due_date ? \Carbon\Carbon::parse($invoice->due_date)->format('d-m-Y') : ''); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->final_amount); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    0
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php
                                                        $status = optional($payment_status->firstWhere('id', $invoice->status))->name;
                                                        $badgeClass = match($status) {
                                                            'Paid' => 'bg-success',
                                                            'Partially Paid' => 'bg-warning',
                                                            'Unpaid' => 'bg-danger',                                                          
                                                        };
                                                    ?>
                                                
                                                    <span class="badge <?php echo e($badgeClass); ?>">
                                                        <?php echo e($status ?? 'Unknown'); ?>

                                                    </span>
                                                </p>
                                            </td>
                                            <td><?php echo e($invoice->createdBy->name ?? ''.' '. $invoice->createdBy->last_name ?? ''); ?></td>
                                            <td >
                                                <a href="<?php echo e(route('invoice-edit', $invoice->id)); ?>">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <form action="<?php echo e(route('invoice-delete', $invoice->id)); ?>" method="POST"
                                                    class="d-inline" id="delete-form-<?php echo e($invoice->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>                                                    
                                                        <i class="cursor-pointer fas fa-trash text-secondary ms-2" onclick="confirmDelete(<?php echo e($invoice->id); ?>)"></i>                                                   
                                                </form>
                                                <?php
                                                ?>
                                                <a href="<?php echo e(route('pdf',$invoice->id)); ?>">
                                                    <i class="fa-solid fa-download text-secondary ms-2"></i>
                                                </a>
                                            </td>
                                        </tr>                                    
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + id).submit();
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/invoices/index.blade.php ENDPATH**/ ?>