<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="76x76" href="../assets/img/apple-icon.png">
    <link rel="icon" type="image/png" href="../assets/img/favicon.png">
    <title>
        Billing
    </title>

    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />

    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/style.css')); ?>" rel="stylesheet" />
    <link type="text/css" rel="stylesheet" href="<?php echo e(asset('assets/fonts/font-awesome/css/font-awesome.min.css')); ?>">
    <link href="<?php echo e(asset('assets/css/nucleo-icons.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />

    <link href="<?php echo e(asset('assets/css/nucleo-svg.css')); ?>" rel="stylesheet" />

    <link id="pagestyle" href="<?php echo e(asset('assets/css/soft-ui-dashboard.css?v=1')); ?>" rel="stylesheet" />
    <style>
        .invoice-1 {
            width: 100%;
            max-width: 1140px;
            margin: 0 auto;
        }

        .invoice-inner {
            padding: 40px;
            background: #fff;
        }

        .invoice-headar h1 {
            font-size: 36px;
            /* Larger heading */
        }

        .invoice-table {
            font-size: 16px;
            /* Larger font for table */
        }

        .invoice-table th,
        .invoice-table td {
            padding: 12px 15px;
            /* More cell padding */
        }

        .table-responsive {
            overflow: visible;
            /* Allow table to use full width */
        }

        .invoice-info {
            width: 100%;
        }

        /* Adjust column widths */
        .invoice-table th:nth-child(1),
        .invoice-table td:nth-child(1) {
            width: 5%;
        }

        .invoice-table th:nth-child(2),
        .invoice-table td:nth-child(2) {
            width: 45%;
            /* More space for description */
            text-align: left;
            padding-left: 0;
        }

        .invoice-table th:nth-child(3),
        .invoice-table td:nth-child(3),
        .invoice-table th:nth-child(4),
        .invoice-table td:nth-child(4) {
            width: 15%;
        }

        .invoice-table th:nth-child(5),
        .invoice-table td:nth-child(5) {
            width: 20%;
        }

        /* Larger logo */
        .invoice-logo img {
            max-height: 100px;
        }

        .invoice-btn-section .row {
            display: flex;
            flex-wrap: nowrap;
            align-items: center;
        }

        .invoice-btn-section .btn {
            white-space: nowrap;
            margin: 0 5px;
        }

        .invoice-btn-section .form-select {
            min-width: 200px;
        }

        @media (max-width: 768px) {
            .invoice-btn-section .row {
                flex-wrap: wrap;
            }

            .invoice-btn-section .col-md-auto,
            .invoice-btn-section .col-md-3 {
                width: 100%;
                margin-bottom: 10px;
            }
        }
             @media print {
        body, .invoice-inner, .invoice-info, .invoice-table {
            float: none !important;
            margin: 0 !important;
            padding: 0 !important;
            width: 100% !important;
        }

        .invoice-id .info {
            font-size: 12px !important;
        }
        
        .invoice-id h1.inv-header-1 {
            font-size: 18px !important;
            margin-bottom: 4px !important;
        }
        
        .invoice-id p {
            font-size: 11px !important;
            margin-bottom: 2px !important;
        }
        
        .invoice-id span {
            font-size: 11px !important;
        }
        .invoice-table {
            margin-left: 0 !important;
            margin-right: auto !important;
        }
       
    }
    </style>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
</head>

<body>
    <div class="invoice-1 invoice-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="invoice-inner clearfix">
                        <div class="invoice-info clearfix" id="invoice_wrapper">
                            <div class="invoice-headar">
                                <div class="row g-0">
                                    <div class="col-sm-6">
                                        <div class="invoice-logo">
                                            <!-- logo started -->
                                            <div class="logo">
                                                <img src="<?php echo e(getFileUrl($settings->logo ? $settings->logo : 'storage/logo/logo_invoice.png')); ?>"
                                                    alt="logo">
                                            </div>
                                            <!-- logo ended -->
                                        </div>
                                    </div>
                                    <div class="col-sm-6 invoice-id">
                                        <div class="info">
                                            <h1 class="color-white inv-header-1">Invoice</h1>
                                            <p class="color-white mb-1">Invoice Number
                                                <span><?php echo e($addedInvoice->invoice_id ?? ''); ?></span>
                                            </p>
                                            <p class="color-white mb-0">Invoice Date
                                                <span><?php echo e($addedInvoice->invoice_date ? \Carbon\Carbon::parse($addedInvoice->invoice_date)->format('d-m-Y') : ''); ?></span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="invoice-top">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="invoice-number mb-30">
                                            <h4 class="inv-title-1">Invoice To</h4>
                                            <h2 class="name"><?php echo e($addedInvoice->client->user->name ?? ''); ?></h2>
                                            <p class="invo-addr-1">
                                                (+91) <?php echo e($addedInvoice->client->user->phone ?? ''); ?> <br />
                                            </p>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="invoice-number mb-30">
                                            <div class="invoice-number-inner">
                                                <h4 class="inv-title-1">Invoice From</h4>
                                                <h2 class="name"><?php echo e($settings->company_name ?? ''); ?></h2>
                                                <p class="invo-addr-1">
                                                    <?php echo e($settings->address ?? ''); ?> <br />
                                                    <?php echo e($settings->email ?? ''); ?> <br />
                                                    (+91) <?php echo e($settings->phone ?? ''); ?>

                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="table-responsive">
                                    <table class="table mb-0 table-striped invoice-table">
                                        <thead class="bg-active">
                                            <tr class="tr">
                                                <th>No.</th>
                                                <th class="pl0 text-start">Item Description</th>
                                                <th class="text-center">Price</th>
                                                <th class="text-center">Quantity</th>
                                                <th class="text-end">Amount</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $addedInvoice->invoiceItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="tr">
                                                    <td>
                                                        <div class="item-desc-1">
                                                            <span><?php echo e($index + 1); ?></span>
                                                        </div>
                                                    </td>
                                                    <td class="pl0"><?php echo e($data->product_name ?? ''); ?></td>
                                                    <td class="text-center"><?php echo e($data->price ?? ''); ?></td>
                                                    <td class="text-center"><?php echo e($data->quantity ?? ''); ?></td>
                                                    <td class="text-end"><?php echo e($data->total ?? ''); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            <tr class="tr2">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-center">SubTotal</td>
                                                <td class="text-end">₹<?php echo e(number_format($addedInvoice->amount ?? 0, 2)); ?>

                                                </td>
                                            </tr>
                                            <tr class="tr2">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-center">Tax</td>
                                                <td class="text-end">
                                                    <?php
                                                        $totalTax = 0;
                                                        foreach ($addedInvoice->invoiceItems as $item) {
                                                            if ($item->invoiceItemTaxes) {
                                                                foreach ($item->invoiceItemTaxes as $tax) {
                                                                    $totalTax += ($item->total * $tax->tax) / 100;
                                                                }
                                                            }
                                                        }
                                                    ?>
                                                    ₹<?php echo e(number_format($totalTax, 2)); ?>

                                                </td>
                                            </tr>
                                            <tr class="tr2">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-center">Discount</td>
                                                <td class="text-end">
                                                    <?php
                                                        $totalDiscount = 0;
                                                        $total = $addedInvoice->amount + $totalTax;
                                                        if ($addedInvoice->discount_type == 1) {
                                                            $totalDiscount = $addedInvoice->discount;
                                                        } elseif ($addedInvoice->discount_type == 2) {
                                                            $discountAmount = ($total * $addedInvoice->discount)
                                                                / 100;
                                                            $totalDiscount = $discountAmount;
                                                        } else {
                                                            $totalDiscount = 0;
                                                        }                                            
                                                    ?>
                                                    ₹ <?php echo e(number_format($totalDiscount ?? 0, 2)); ?></td>
                                            </tr>
                                            <tr class="tr2">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-center f-w-600 active-color">Grand Total</td>
                                                <td class="f-w-600 text-end active-color">₹
                                                    <?php echo e(number_format(floor($total - $totalDiscount) ?? 0, 2)); ?>

                                                </td>
                                            </tr>
                                            <tr class="tr2">
                                                <td></td>
                                                <td></td>
                                                <td></td>
                                                <td class="text-center f-w-600 ">Total Purchased Product Qty
                                                </td>
                                                <td class="f-w-600 text-end ">
                                                    <?php
                                                        $sumQty = 0;
                                                        foreach ($addedInvoice->invoiceItems as $item) {
                                                            $sumQty += $item->quantity;
                                                        }                      
                                                    ?>
                                                    <?php echo e($sumQty ?? 0); ?>

                                                </td>
                                            </tr>
                                             <?php if(isset($settings->declaration)): ?>
                                                <tr class="tr2">
                                                    <td class="text-center  text-wrap" colspan="5"><strong>Terms & Condition : </strong>
                                                         <?php echo e($settings->declaration ?? ''); ?>

                                                    </td>                                                   
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="invoice-bottom">
                                <div class="row">
                                </div>
                            </div>

                            <div class="invoice-btn-section clearfix d-print-none">
                                <div class="row align-items-center gx-2 gy-2 mt-0">
                                    <div class="col-md-3">
                                        <select name="paper_size" id="paper_size" class="form-select">
                                            <option value="">Select Standard paper size</option>
                                            <?php $__currentLoopData = $paper; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-auto">
                                        <a href="javascript:window.print()" class="btn">
                                            <i class="fa fa-print"></i> Print Invoice
                                        </a>
                                    </div>
                                    

                                    <?php if($settings->whatsapp_config == 'A'): ?>
                                        <div class="col-md-auto">
                                            <a href="#" id="send_invoice" class="btn">
                                                <i class="fa-brands fa-whatsapp"></i>Send Invoice
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-md-auto">
                                        <a href='<?php echo e(route('invoice-index')); ?>' id="cancel-btn" class="btn">
                                            <i class="fa fa-arrow-left"></i> Back
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="<?php echo e(asset('assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/core/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/smooth-scrollbar.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/jspdf.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/html2canvas.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
    <script>
        $(function () {
            'use strict';

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(document).on('click', '#invoice_download_btn', function () {
                $(".invoice-btn-section").addClass('d-none');

                // Get the invoice wrapper element
                const element = $("#invoice_wrapper")[0];
                const scale = 2; // Higher scale for better quality

                // Options for html2canvas
                const options = {
                    scale: scale,
                    logging: false,
                    useCORS: true,
                    allowTaint: true,
                    scrollX: 0,
                    scrollY: 0,
                    windowWidth: element.scrollWidth,
                    windowHeight: element.scrollHeight
                };

                html2canvas(element, options).then(function (canvas) {
                    // Calculate PDF dimensions
                    const imgWidth = 210; // A4 width in mm
                    const imgHeight = (canvas.height * imgWidth) / canvas.width;

                    // Create PDF
                    const pdf = new jsPDF('p', 'mm', 'a4');

                    // Add image to PDF
                    const imgData = canvas.toDataURL('image/jpeg', 1.0);
                    pdf.addImage(imgData, 'JPEG', 0, 0, imgWidth, imgHeight);

                    // Save the PDF
                    const pdfBlob = pdf.output('blob');
                    const formData = new FormData();
                    formData.append("pdf_file", pdfBlob, "invoice.pdf");

                    $.ajax({
                        url: '<?php echo e(route('invoice.save')); ?>',
                        method: 'POST',
                        data: formData,
                        contentType: false,
                        processData: false,
                        success: function (response) {
                            console.log("File saved successfully on the server.");
                            pdf.save("<?php echo e($addedInvoice->invoice_id); ?>.pdf");
                            $(".invoice-btn-section").removeClass('d-none');
                        },
                        error: function (error) {
                            console.log("Error saving the file:", error);
                            $(".invoice-btn-section").removeClass('d-none');
                        }
                    });
                });
            });
        });
    </script>
    <script>
        $(function () {
            $(document).on('click', '#send_invoice', function () {
                $(".invoice-btn-section").hide();

                var content = $("#invoice_wrapper")[0];
                var contentWidth = content.offsetWidth;
                var contentHeight = content.offsetHeight;
                var pdfWidth = 80;
                var pdfHeight = (contentHeight * pdfWidth) / contentWidth;

                html2canvas(content, {
                    allowTaint: true,
                    scale: 2,
                    useCORS: true
                }).then(function (canvas) {
                    var imgData = canvas.toDataURL("image/jpeg", 1.0);
                    var pdf = new jsPDF('p', 'mm', [pdfWidth, pdfHeight]);
                    pdf.addImage(imgData, 'JPEG', 0, 0, pdfWidth, pdfHeight);

                    var pdfBlob = pdf.output('blob');
                    var formData = new FormData();
                    formData.append("invoice_pdf", pdfBlob, "invoice_<?php echo e($addedInvoice->invoice_id); ?>.pdf");
                    formData.append("_token", "<?php echo e(csrf_token()); ?>");
                    formData.append("invoice_id", "<?php echo e($addedInvoice->invoice_id); ?>");
                    formData.append("invoice_amnt", "<?php echo e($addedInvoice->final_amount); ?>");
                    formData.append("phone_number", "<?php echo e($addedInvoice->client->user->phone ?? ''); ?>");
                    // Send the PDF to the backend
                    $.ajax({
                        url: "<?php echo e(route('send.invoice')); ?>",
                        type: "POST",
                        data: formData,
                        processData: false,
                        contentType: false,
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    title: "Success!",
                                    text: "Message sent successfully!",
                                    icon: "success",
                                    confirmButtonText: "OK"
                                })
                            } else {
                                Swal.fire({
                                    title: "Error!",
                                    text: "Error sending invoice!",
                                    icon: "error",
                                    confirmButtonText: "OK"
                                });
                            }
                            $(".invoice-btn-section").show();
                        },
                        error: function () {
                            Swal.fire({
                                title: "Error!",
                                text: "Something went wrong while processing the request.",
                                icon: "error",
                                confirmButtonText: "OK"
                            });
                            $(".invoice-btn-section").show();
                        }
                    });
                });
            });
        });       
    </script>
    <script>
        $(function () {
            $(document).on('change', '#paper_size', function () {
                const paperId = $('#paper_size').val();
                const invoiceId = "<?php echo e($addedInvoice->id); ?>";

                window.location.href = "<?php echo e(route('pdf', ['id' => 'INVOICE_ID_PLACEHOLDER'])); ?>".replace('INVOICE_ID_PLACEHOLDER', invoiceId) + "?paperId=" + paperId;
            });
        });
    </script>
</body>

</html><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/pdf/a4Pdf.blade.php ENDPATH**/ ?>