

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Update Client</h5>
                </div>
                <div class="card-body">
                    <?php if(isset($client)): ?>
                    <form action="<?php echo e(route('client-update')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="client_id" id="client_id" value="<?php echo e($client->id); ?>">
                        <div class="row">
                            <div class="col-lg-6 row">
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_first_name" class="form-label">First Name:</label>
                                    <input type="text" id="edit_first_name" name="first_name" class="form-control" 
                                           value="<?php echo e(old('first_name', $client->user->name)); ?>" placeholder="Enter first name" required>
                                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_last_name" class="form-label">Last Name:</label>
                                    <input type="text" id="edit_last_name" name="last_name" class="form-control" 
                                           value="<?php echo e(old('last_name', $client->user->last_name)); ?>" placeholder="Enter last name" required>
                                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_email" class="form-label">Email:</label>
                                    <input type="email" id="edit_email" name="email" class="form-control" 
                                           value="<?php echo e(old('email', $client->user->email)); ?>" placeholder="Enter email address" required>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_contact_no" class="form-label">Contact No:</label>
                                    <input type="number" id="edit_contact_no" name="contact_no" class="form-control" 
                                           value="<?php echo e(old('contact_no', $client->user->phone)); ?>" placeholder="Enter contact number" required>
                                    <?php $__errorArgs = ['contact_no'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_website" class="form-label">Website:</label>
                                    <input type="text" id="edit_website" name="website" class="form-control" 
                                           value="<?php echo e(old('website', $client->website)); ?>" placeholder="Enter website URL (optional)">
                                    <?php $__errorArgs = ['website'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_postal_code" class="form-label">Postal Code:</label>
                                    <input type="number" id="edit_postal_code" name="postal_code" class="form-control" 
                                           value="<?php echo e(old('postal_code', $client->postal_code)); ?>" placeholder="Enter postal code" required>
                                    <?php $__errorArgs = ['postal_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_country" class="form-label">Country:</label>
                                    <select id="edit_country" name="country" class="form-control" required 
                                            onchange="getEditStates(this.value, '<?php echo e($client->state_id); ?>')">
                                        <option value="" selected>Select country</option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->id); ?>" 
                                                <?php echo e($country->id == $client->country_id ? 'selected' : ''); ?>>
                                                <?php echo e($country->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_state" class="form-label">State:</label>
                                    <select id="edit_state" name="state" class="form-select" required 
                                            onchange="getEditCities(this.value, '<?php echo e($client->city_id); ?>')">
                                        <option value="" selected>Select state</option>
                                        <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($state->id); ?>" 
                                                <?php echo e($state->id == $client->state_id ? 'selected' : ''); ?>>
                                                <?php echo e($state->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_city" class="form-label">City:</label>
                                    <select id="edit_city" name="city" class="form-select" required>
                                        <option value="" selected>Select city</option>
                                        <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($city->id); ?>" 
                                                <?php echo e($city->id == $client->city_id ? 'selected' : ''); ?>>
                                                <?php echo e($city->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['city'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_company_name" class="form-label">Company Name:</label>
                                    <input type="text" id="edit_company_name" name="company_name" class="form-control" 
                                           value="<?php echo e(old('company_name', $client->company_name)); ?>" placeholder="Enter company name" required>
                                    <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-lg-6 row">
                                <div class="col-12 mb-7">
                                    <label for="edit_profile_image" class="form-label">Profile:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-upload me-5">
                                            <div class="avatar-preview">
                                                <img id="editProfilePreview" src="<?php echo e($client->profile_img ? getFileUrl($client->profile_img) : asset('assets/img/logos/profile.png')); ?>" 
                                                     alt="Profile Image" class="img-fluid rounded-circle" style="height:125px;">
                                            </div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type="file" id="edit_profile_image" name="profile_image" 
                                                   class="form-control file-upload-input" accept="image/*" onchange="previewEditImage(this)">
                                        </div>
                                    </div>
                                    <?php $__errorArgs = ['profile_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_address" class="form-label">Address:</label>
                                    <input type="text" id="edit_address" name="address" class="form-control" 
                                           value="<?php echo e(old('address', $client->address)); ?>" placeholder="Enter full address" required>
                                    <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_notes" class="form-label">Notes:</label>
                                    <input type="text" id="edit_notes" name="notes" class="form-control" 
                                           value="<?php echo e(old('notes', $client->note)); ?>" placeholder="Enter any notes (optional)">
                                    <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_gstin" class="form-label">GSTIN:</label>
                                    <input type="text" id="edit_gstin" name="gstin" class="form-control" 
                                           value="<?php echo e(old('gstin', $client->gstin)); ?>" placeholder="Enter GSTIN number (optional)">
                                    <?php $__errorArgs = ['gstin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_active_status" class="form-label">Active Status:</label>
                                    <select id="edit_active_status" name="active_status" class="form-select">
                                        <option value="A" <?php echo e($client->active_status == 'A' ? 'selected' : ''); ?>>Active</option>
                                        <option value="I" <?php echo e($client->active_status == 'I' ? 'selected' : ''); ?>>Inactive</option>
                                    </select>
                                    <?php $__errorArgs = ['active_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12 text-end">
                                <button type="submit" class="btn btn-primary">Update Client</button>
                                <a href="<?php echo e(route('client-index')); ?>" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>
                    </form>
                    <?php else: ?>
                    <div class="alert alert-danger">
                        Client data not found!
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function previewEditImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('editProfilePreview').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    function getEditStates(countryId, selectedStateId = null) {
        if (!countryId) {
            document.getElementById('edit_state').innerHTML = '<option value="">Select state</option>';
            document.getElementById('edit_city').innerHTML = '<option value="">Select city</option>';
            return;
        }

        fetch(`/getStates/${countryId}`)
            .then(response => response.json())
            .then(data => {
                const stateSelect = document.getElementById('edit_state');
                stateSelect.innerHTML = '<option value="">Select state</option>';
                data.forEach(state => {
                    const selected = state.id == selectedStateId ? 'selected' : '';
                    stateSelect.innerHTML += `<option value="${state.id}" ${selected}>${state.name}</option>`;
                });
                
                // If a state was pre-selected, trigger city loading
                if (selectedStateId) {
                    getEditCities(selectedStateId, '<?php echo e($client->city_id ?? null); ?>');
                }
            });
    }

    function getEditCities(stateId, selectedCityId = null) {
        if (!stateId) {
            document.getElementById('edit_city').innerHTML = '<option value="">Select city</option>';
            return;
        }

        fetch(`/getCities/${stateId}`)
            .then(response => response.json())
            .then(data => {
                const citySelect = document.getElementById('edit_city');
                citySelect.innerHTML = '<option value="">Select city</option>';
                data.forEach(city => {
                    const selected = city.id == selectedCityId ? 'selected' : '';
                    citySelect.innerHTML += `<option value="${city.id}" ${selected}>${city.name}</option>`;
                });
            });
    }

    // Initialize states and cities when page loads if country is selected
    document.addEventListener('DOMContentLoaded', function() {
        const countrySelect = document.getElementById('edit_country');
        if (countrySelect && countrySelect.value) {
            getEditStates(countrySelect.value, '<?php echo e($client->state_id ?? null); ?>');
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/clients/edit.blade.php ENDPATH**/ ?>