

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Update Payment</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('product-payment-update')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="payment_id" value="<?php echo e($product->product_details_sid); ?>">
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="product_dtl_id" class="form-label">Product:</label>
                                    <select class="form-select" name="product_dtl_id" disabled>
                                        <option value="<?php echo e($product->product_details_sid); ?>">
                                            <?php echo e($product->name); ?> / <?php echo e($product->code); ?>

                                        </option>
                                    </select>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="total_amount" class="form-label">Total Amount:</label>
                                    <input type="text" class="form-control" name="totalAmount" value="<?php echo e($totalAmount); ?>"
                                        readonly>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="due_amount" class="form-label">Due Amount:</label>
                                    <input type="text" class="form-control" value="<?php echo e($dueAmount); ?>" readonly>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label class="form-label">Paid Amount</label>
                                    <input type="text" class="form-control" name="paidAmount" value="<?php echo e($totalPaidAmount); ?>"
                                        readonly>
                                </div>

                                <div class="col-lg-4 mb-4">
                                    <label for="payment_date" class="form-label">Payment Date</label>
                                    <input type="date" id="payment_date" class="form-control" name="payment_date"
                                        value="<?php echo e(old('payment_date', now()->toDateString())); ?>" required>
                                    <?php $__errorArgs = ['payment_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="text" id="amount" class="form-control" name="amount"
                                        value="<?php echo e(old('amount')); ?>" required>
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="payment_type" class="form-label">Payment Method</label>
                                    <select name="payment_type" class="form-select" required>
                                        <option value="">Select Payment Method</option>
                                        <option value="cash" <?php echo e(old('payment_type') == 'cash' ? 'selected' : ''); ?>>Cash
                                        </option>
                                        <option value="upi" <?php echo e(old('payment_type') == 'upi' ? 'selected' : ''); ?>>Upi</option>
                                        <option value="online" <?php echo e(old('payment_type') == 'online' ? 'selected' : ''); ?>>Online
                                        </option>
                                    </select>
                                    <?php $__errorArgs = ['payment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="table-responsive p-0 mt-4">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                                Product</th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                                Payment Date</th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Amount</th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Payment Method</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $cumulativeTotal = 0; ?>
                                        <?php $__empty_1 = true; $__currentLoopData = $paymentsForProduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0"><?php echo e($payment->product_dtls->name); ?>

                                                        / <?php echo e($payment->product_dtls->code); ?></p>
                                                </td>
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        <?php echo e(\Carbon\Carbon::parse($payment->payment_date)->format('d/m/Y')); ?>

                                                    </p>
                                                </td>
                                                <td class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0"><?php echo e($payment->paid_amount); ?></p>
                                                </td>
                                                <td class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        <?php echo e($payment->payment_type ?? 'Unknown'); ?>

                                                    </p>
                                                </td>
                                            </tr>
                                            <?php $cumulativeTotal += $payment->paid_amount; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="4" class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">No Payments found.</p>
                                                </td>
                                            </tr>
                                        <?php endif; ?>

                                        <?php if($cumulativeTotal > 0): ?>
                                            <tr>
                                                <td colspan="2" class="text-end text-xs font-weight-bold">Total Amount:</td>
                                                <td class="text-center text-xs font-weight-bold"><?php echo e($cumulativeTotal); ?></td>
                                                <td colspan="1"></td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-primary">Update Payment</button>
                                <a href="<?php echo e(route('product-payment-index')); ?>" class="btn btn-secondary ms-2">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling/resources/views/product-payments/edit.blade.php ENDPATH**/ ?>