@extends('layouts.layoutapp')
@section('content')
    <div class="main-content">
        <!-- Suppliers List Section -->
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h5 class="mb-0">All Suppliers</h5>
                            <div>
                                <a href="{{ route('supplier-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+ Add
                                    Supplier</a>
                                <a href="{{route('supplier-import-index')}}" class="btn bg-gradient-primary btn-sm mb-0">
                                    Bulk
                                    Import</a>
                            </div>
                        </div>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body px-0 pt-0 pb-2">
                        <!-- Suppliers Table -->
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Name</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Email</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Status</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Address</th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($suppliers as $supplier)
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $supplier->supplier_name }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $supplier->email }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $supplier->active_status ? 'Yes' : 'No' }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $supplier->address }}</p>
                                            </td>
                                            <td class="text-center">
                                                <!-- Update Supplier -->
                                                <a href="{{ route('supplier-edit', $supplier->id) }}">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                &nbsp;
                                                <!-- Delete Supplier -->
                                                <form action="{{ route('supplier-delete', ['id' => $supplier->id]) }}"
                                                    method="POST" class="d-inline" id="delete-form-{{$supplier->id}}">
                                                    @csrf
                                                    @method('DELETE')
                                                    <i class="cursor-pointer fas fa-trash text-secondary"
                                                        onclick="confirmDelete({{$supplier->id}})"></i>
                                                </form>
                                            </td>
                                        </tr>                                    
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        function confirmDelete(id) {
            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('delete-form-' + id).submit();
                }
            });
        }
    </script>
@endpush