@extends('layouts.layoutapp')

@section('content')

    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-body">
                        <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                            <form method="GET" action="{{ route('product-Report') }}" class="d-flex align-items-center">

                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                        id="start_date" name="start_date"
                                        value="{{ old('start_date', request()->get('start_date')) }}">

                                    <!-- Display error message for start_date -->
                                    @error('start_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                        id="end_date" name="end_date"
                                        value="{{ old('end_date', request()->get('end_date')) }}">

                                    <!-- Display error message for end_date -->
                                    @error('end_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">

                                    <select name="status" id="status" class="form-control">
                                        <option value="">Filters</option>
                                        <option value=" " {{ request()->get('status') == 'all' ? 'selected' : '' }}>All
                                        </option>
                                        <option value="current" {{ request()->get('status') == 'current' ? 'selected' : '' }}>
                                            Current
                                            Products</option>
                                        <option value="A" {{ request()->get('status') == 'added' ? 'selected' : '' }}>Added
                                        </option>
                                        <option value="D" {{ request()->get('status') == 'deleted' ? 'selected' : '' }}>
                                            Deleted
                                        </option>
                                        <option value="E" {{ request()->get('status') == 'updated' ? 'selected' : '' }}>
                                            Updated
                                        </option>
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </form>
                        </div>

                        <div class="table-responsive">
                            <table class="table align-items-center mb-0 table-hover text-sm" id="myTable">
                                <thead>
                                    <tr>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Product Name
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Category
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Avl. Qty
                                        </th>
                                        <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Price</th>
                                        {{-- <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Product
                                            Code</th> --}}

                                        @if($status != 'current')
                                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Created by
                                            </th>
                                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Date</th>
                                        @endif


                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($results as $data)
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->name }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->category->name }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->qty }}</p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->unit_price }}</p>
                                            </td>
                                            {{-- <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->code }}</p>
                                            </td> --}}
                                            @if($status != 'current')
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        {{ $data->user ? $data->user->name : 'Unknown' }}
                                                    </p>
                                                </td>
                                                @if($status == 'E')
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            {{ $data->updated_at->toDateString() ? \Carbon\Carbon::parse($data->updated_at->toDateString())->format('d-m-Y') : '' }}
                                                        </p>
                                                    </td>
                                                @else
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            {{ $data->created_at->toDateString() ? \Carbon\Carbon::parse($data->created_at->toDateString())->format('d-m-Y') : '' }}
                                                        </p>
                                                    </td>
                                                @endif
                                            @endif

                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
{{-- @push('scripts')
<script>
    window.onload = function () {
        document.getElementById('start_date').value = '';
        document.getElementById('end_date').value = '';
        document.getElementByID('status').value = '';
    }
</script>
@endpush --}}