@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header d-flex justify-content-between">
                        <div>
                            <h4>Invoice GST Report</h4>
                        </div>
                        <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                            <form method="GET" action="{{ route('gst-report') }}" class="d-flex align-items-center">
                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                                        id="start_date" name="start_date"
                                        value="{{ old('start_date', request()->get('start_date')) }}">

                                    <!-- Display error message for start_date -->
                                    @error('start_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="form-group me-3">
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror"
                                        id="end_date" name="end_date"
                                        value="{{ old('end_date', request()->get('end_date')) }}">

                                    <!-- Display error message for end_date -->
                                    @error('end_date')
                                        <div class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="form-group me-2">
                                    <select name="status" id="status" class="form-select">
                                        <option value="">Select Status</option>
                                        @foreach ($statusList as $id => $name)
                                            <option value="{{ $id }}" {{ old('status') == $id ? 'selected' : '' }}>
                                                {{ $name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </form>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table text-sm" id="myTable">
                                <thead>
                                    <tr>
                                        <th class="text-center">Invoice Id</th>
                                        <th class="text-center">Client Name</th>
                                        <th class="text-center">Branch Name</th>
                                        <th class="text-center">Invoice Date</th>
                                        <th class="text-center">Due Date</th>
                                        <th class="text-center">Tax</th>
                                        <th class="text-center">Amount</th>
                                        <th class="text-center">Discount Type & Amount</th>
                                        <th class="text-center">Total Amount</th>
                                        <th class="text-center">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($invoice as $item)
                                                                    <tr>
                                                                        <td class="text-center">{{$item->invoice_id ?? ''}} </td>
                                                                        <td class="text-center">{{$item->client->user->name ?? ''}} </td>
                                                                        <td class="text-center">{{$item->branch->name ?? ''}} </td>
                                                                        <td class="text-center">{{$item->invoice_date ?? ''}} </td>
                                                                        <td class="text-center">{{$item->due_date ?? ''}} </td>

                                                                        <td class="text-center">
                                                                            @php
                                                                                $totalTax = 0;
                                                                                if (isset($item->invoiceItems) && $item->invoiceItems->isNotEmpty()) {
                                                                                    foreach ($item->invoiceItems as $invoiceItem) {
                                                                                        if ($invoiceItem->invoiceItemTaxes->isNotEmpty()) {
                                                                                            foreach ($invoiceItem->invoiceItemTaxes as $tax) {
                                                                                                $totalTax += round(($invoiceItem->total * $tax->tax) / 100, 2);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                                echo number_format($totalTax, 2);
                                                                            @endphp
                                                                        </td>
                                                                        <td class="text-center">{{$item->amount ?? ''}} </td>
                                                                        <td class="text-start">
                                                                            @php
                                                                                if (isset($item->discountType) && $item->discountType->type == 'Fixed') {
                                                                                    $discountAmount = $item->discount;
                                                                                } elseif (isset($item->discountType) && $item->discountType->type == 'Percentege') {
                                                                                    $discountAmount = round(($item->amount + $totalTax) * ($item->discount / 100), 2);
                                                                                } else {
                                                                                    $discountAmount = 'Not set';
                                                                                }
                                                                            @endphp
                                                                            {{$discountAmount ?? ''}}@if (isset($item->discountType))
                                                                                ({{$item->discountType->type ?? ''}})
                                                                            @endif
                                                                        </td>
                                                                        <td class="text-center">{{ number_format(floor($item->final_amount) ?? '', 2) }}
                                                                        </td>
                                                                        <td class="text-center">{{$statusList[$item->status] ?? 'Unknown' }} </td>
                                                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection