@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Update Payment</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('product-payment-update') }}" method="POST">
                            @csrf
                            <input type="hidden" name="payment_id" value="{{$product->product_details_sid}}">
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="product_dtl_id" class="form-label">Product:</label>
                                    <select class="form-select" name="product_dtl_id" disabled>
                                        <option value="{{ $product->product_details_sid }}">
                                            {{ $product->name }} / {{ $product->code }}
                                        </option>
                                    </select>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="total_amount" class="form-label">Total Amount:</label>
                                    <input type="text" class="form-control" name="totalAmount" value="{{ $totalAmount }}"
                                        readonly>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="due_amount" class="form-label">Due Amount:</label>
                                    <input type="text" class="form-control" value="{{ $dueAmount }}" readonly>
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label class="form-label">Paid Amount</label>
                                    <input type="text" class="form-control" name="paidAmount" value="{{ $totalPaidAmount }}"
                                        readonly>
                                </div>

                                <div class="col-lg-4 mb-4">
                                    <label for="payment_date" class="form-label">Payment Date</label>
                                    <input type="date" id="payment_date" class="form-control" name="payment_date"
                                        value="{{ old('payment_date', now()->toDateString()) }}" required>
                                    @error('payment_date') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="text" id="amount" class="form-control" name="amount"
                                        value="{{ old('amount') }}" required>
                                    @error('amount') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="payment_type" class="form-label">Payment Method</label>
                                    <select name="payment_type" class="form-select" required>
                                        <option value="">Select Payment Method</option>
                                        <option value="cash" {{ old('payment_type') == 'cash' ? 'selected' : '' }}>Cash
                                        </option>
                                        <option value="upi" {{ old('payment_type') == 'upi' ? 'selected' : '' }}>Upi</option>
                                        <option value="online" {{ old('payment_type') == 'online' ? 'selected' : '' }}>Online
                                        </option>
                                    </select>
                                    @error('payment_type') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div class="table-responsive p-0 mt-4">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                                Product</th>
                                            <th
                                                class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                                Payment Date</th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Amount</th>
                                            <th
                                                class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                                Payment Method</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php $cumulativeTotal = 0; @endphp
                                        @forelse ($paymentsForProduct as $payment)
                                            <tr>
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0">{{ $payment->product_dtls->name }}
                                                        / {{ $payment->product_dtls->code }}</p>
                                                </td>
                                                <td class="ps-4">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        {{ \Carbon\Carbon::parse($payment->payment_date)->format('d/m/Y') }}
                                                    </p>
                                                </td>
                                                <td class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">{{ $payment->paid_amount }}</p>
                                                </td>
                                                <td class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">
                                                        {{ $payment->payment_type ?? 'Unknown' }}
                                                    </p>
                                                </td>
                                            </tr>
                                            @php $cumulativeTotal += $payment->paid_amount; @endphp
                                        @empty
                                            <tr>
                                                <td colspan="4" class="text-center">
                                                    <p class="text-xs font-weight-bold mb-0">No Payments found.</p>
                                                </td>
                                            </tr>
                                        @endforelse

                                        @if($cumulativeTotal > 0)
                                            <tr>
                                                <td colspan="2" class="text-end text-xs font-weight-bold">Total Amount:</td>
                                                <td class="text-center text-xs font-weight-bold">{{ $cumulativeTotal }}</td>
                                                <td colspan="1"></td>
                                            </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>

                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-primary">Update Payment</button>
                                <a href="{{ route('product-payment-index') }}" class="btn btn-secondary ms-2">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection