@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add Payment</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('product-payment-store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="product_dtl_id" class="form-label">Product:</label>
                                    <select class="form-select select2" id="product_dtl_id" name="product_dtl_id" required>
                                        <option value="">Select Product</option>
                                        @foreach($product_dtls as $data)
                                            <option value="{{ $data->product_details_sid }}">{{ $data->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('product_dtl_id') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="total_amount" class="form-label">Total Amount:</label>
                                    <input type="text" id="total_amount" class="form-control" name="total_amount" readonly>
                                    @error('total_amount') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="due_amount" class="form-label">Due Amount:</label>
                                    <input type="text" id="due_amount" class="form-control" name="due_amount" readonly>
                                    @error('due_amount') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>

                                <div class="col-lg-4 mb-4">
                                    <label for="payment_date" class="form-label">Payment Date</label>
                                    <input type="date" id="payment_date" class="form-control" name="payment_date"
                                        value="{{ old('payment_date', now()->toDateString()) }}" required>
                                    @error('payment_date') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="amount" class="form-label">Amount</label>
                                    <input type="text" id="amount" class="form-control" name="amount"
                                        value="{{ old('amount') }}" required>
                                    @error('amount') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="payment_type" class="form-label">Payment Method</label>
                                    <select name="payment_type" class="form-select" required>
                                        <option value="">Select Payment Method</option>
                                        <option value="cash" {{ old('payment_type') == 'cash' ? 'selected' : '' }}>Cash
                                        </option>
                                        <option value="upi" {{ old('payment_type') == 'upi' ? 'selected' : '' }}>Upi</option>
                                        <option value="online" {{ old('payment_type') == 'online' ? 'selected' : '' }}>Online
                                        </option>
                                    </select>
                                    @error('payment_type') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="d-flex justify-content-end">
                                <button type="submit" class="btn btn-primary">Save Payment</button>
                                <a href="{{ route('product-payment-index') }}" class="btn btn-secondary ms-2">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function () {
            $('.select2').select2({
                placeholder: "Search Product",
                allowClear: true
            });

            $('#product_dtl_id').change(function () {
                const productId = $(this).val();
                if (productId) {
                    $.get(`/product-payments/get-product-details/${productId}`, function (data) {
                        $('#total_amount').val(data.totalAmount);
                        $('#due_amount').val(data.dueAmount);
                    }).fail(function () {
                        alert('Failed to fetch product details');
                    });
                } else {
                    $('#total_amount').val('');
                    $('#due_amount').val('');
                }
            });
        });
    </script>
@endpush