@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Invoices</h5>
                            </div>
                            <a href="{{ route('invoice-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                Invoice</a>
                        </div>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            ID</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoice Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Due Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Amount</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Transactions</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Status</th>
                                             <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Created by</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($invoices as $invoice)                                   
                                        <tr>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">{{ $invoice->invoice_id }}</p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $invoice->client->user->name ?? '' }} {{ $invoice->client->user->last_name ?? '' }}
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $invoice->invoice_date ? \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') : '' }}
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $invoice->due_date ? \Carbon\Carbon::parse($invoice->due_date)->format('d-m-Y') : ''}}
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ $invoice->final_amount }}
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    0
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    @php
                                                        $status = optional($payment_status->firstWhere('id', $invoice->status))->name;
                                                        $badgeClass = match($status) {
                                                            'Paid' => 'bg-success',
                                                            'Partially Paid' => 'bg-warning',
                                                            'Unpaid' => 'bg-danger',                                                          
                                                        };
                                                    @endphp
                                                
                                                    <span class="badge {{ $badgeClass }}">
                                                        {{ $status ?? 'Unknown' }}
                                                    </span>
                                                </p>
                                            </td>
                                            <td>{{$invoice->createdBy->name ?? ''.' '. $invoice->createdBy->last_name ?? ''}}</td>
                                            <td >
                                                <a href="{{ route('invoice-edit', $invoice->id) }}">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <form action="{{ route('invoice-delete', $invoice->id) }}" method="POST"
                                                    class="d-inline" id="delete-form-{{$invoice->id}}">
                                                    @csrf
                                                    @method('DELETE')                                                    
                                                        <i class="cursor-pointer fas fa-trash text-secondary ms-2" onclick="confirmDelete({{$invoice->id}})"></i>                                                   
                                                </form>
                                                @php
                                                @endphp
                                                <a href="{{ route('pdf',$invoice->id) }}">
                                                    <i class="fa-solid fa-download text-secondary ms-2"></i>
                                                </a>
                                            </td>
                                        </tr>                                    
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + id).submit();
            }
        });
    }
</script>
@endpush