@extends('layouts.layoutapp')@section('content')

    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add New Invoices EMI</h5>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <form action="{{ route('invoice-emi-store') }}" method="POST" id="invoiceForm">
                            @csrf
                            <div class="row">
                                <div class="col-lg-3 mb-3">
                                    <label for="client_name" class="form-label">Client Name:</label>
                                    <input type="text" name="client_name" id="client_name" class="form-control" value="{{ old('client_name') }}">
                                    <span class="text-danger d-block mt-1" id="client_name_error"></span>
                                    @error('client_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="client_num" class="form-label">Client Number:</label>
                                    <select name="client_num" id="client_num_select" class="select2 form-select" multiple>
                                        @foreach ($clients as $client)
                                            <option value="{{ $client->user->phone }}" {{ in_array($client->user->phone, (array) old('client_num', [])) ? 'selected' : '' }}>
                                                {{ $client->user->phone }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <div id="client_num_error" class="text-danger small" style="display: none;"></div>
                                    @error('client_num')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="invoice_id" class="form-label">Invoice number:</label>
                                    <input type="text" id="invoice_id" class="form-control" value="" readonly>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="invoice_date" class="form-label">Invoice Date:</label>
                                    <input type="date" id="invoice_date" class="form-control" name="invoice_date" 
                                           value="{{ old('invoice_date', \Carbon\Carbon::now()->format('Y-m-d')) }}" required>
                                    @error('invoice_date')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="due_date" class="form-label">Due Date:</label>
                                    <input type="date" id="due_date" class="form-control" name="due_date" 
                                           value="{{ old('due_date', \Carbon\Carbon::now()->format('Y-m-d')) }}" required>
                                    @error('due_date')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="gst" class="form-label">GST/Non-GST:</label>
                                    <select name="gst" id="gst" class="form-select" onchange="toggleTaxes()">
                                        <option value="">Select</option>
                                        <option value="Y" {{ old('gst') == 'Y' ? 'selected' : '' }} selected>GST</option>
                                        <option value="N" {{ old('gst') == 'N' ? 'selected' : '' }}>Non-GST</option>
                                    </select>
                                    @error('gst')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <hr>
                            <div>
                                <h5>Product Details:</h5>
                                <div class="row align-items-center">
                                    <div class="col-lg-4 d-flex align-items-center mb-3">
                                        <i class="fa-solid fa-qrcode" style="width: 30px; height: 30px; margin-right: 10px;"></i>
                                        <input class="form-control" type="text" id="product-code-input" onkeydown="preventFormSubmit(event)">
                                    </div>
                                    <div class="col-lg-4">
                                        <button type="button" onclick="addRow(event)" class="btn btn-primary">
                                            <i class="fas fa-plus"></i> Add Row
                                        </button>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="productsTable">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th>#</th>
                                                <th>Product</th>
                                                <th>Avl. Qty</th>
                                                <th>Qty</th>
                                                <th>Unit Price</th>
                                                <th>Tax</th>
                                                <th>Amount</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody id="productRows">
                                            <!-- Dynamic rows will be added here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row mt-5">
                                <div class="col-lg-6 mb-3 d-flex">
                                    <div class="col-lg-6">
                                        <label for="discount_type" class="form-label">Discount type:</label>
                                        <select name="discount_type" id="discount_type" class="form-select" onchange="calculateTotal()">
                                            <option value="">Select discount type</option>
                                            @foreach ($discount_types as $type)
                                                <option value="{{ $type->id }}" {{ old('discount_type') == $type->id ? 'selected' : '' }}>
                                                    {{ $type->type }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('discount_type')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-6">
                                        <label for="discount" class="form-label">Discount:</label>
                                        <input type="number" id="discount" name="discount" class="form-control" 
                                               value="{{ old('discount') }}" onchange="calculateTotal()" 
                                               {{ empty(old('discount_type')) ? 'readonly' : '' }}>
                                        @error('discount')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-5 mb-3">
                                    <div class="card shadow-lg">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Sub Total:</span>
                                                <span id="subTotalDisplay">0 ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Discount:</span>
                                                <span id="discountDisplay">0 ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Tax:</span>
                                                <span id="taxDisplay">0 ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Total:</span>
                                                <span id="totalDisplay">0 ₹</span>
                                            </div>
                                            <input type="hidden" id="sub_total" name="sub_total" value="0">
                                            <input type="hidden" id="discount_amt" name="discount_amt" value="0">
                                            <input type="hidden" id="tax" name="tax" value="0">
                                            <input type="hidden" id="total_amt" name="total_amt" value="0">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr>
                            <div>
                                <h5>Payment Details:</h5>
                                <div class="row">
                                    <div class="col-lg-3 mb-3">
                                        <label for="status" class="form-label">Status:</label>
                                        <select name="status" id="status" class="form-select" required>
                                            <option value="">Select status</option>
                                            @foreach ($payment_status as $status)
                                                <option value="{{ $status->id }}" data-name="{{ $status->name }}" {{ old('status') == $status->id ? 'selected' : '' }}>
                                                    {{ $status->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('status')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-3 mb-3">
                                        <label for="upi" class="form-label">UPI:</label>
                                        <input type="text" name="upi" id="upi" class="form-control" value="{{ old('upi') }}">
                                        @error('upi')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-3 mb-3">
                                        <label for="cash" class="form-label">Cash:</label>
                                        <input type="text" name="cash" id="cash" class="form-control" value="{{ old('cash') }}">
                                        @error('cash')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-3 mb-3">
                                        <label for="online" class="form-label">Online:</label>
                                        <input type="text" name="online" id="online" class="form-control" value="{{ old('online') }}">
                                        @error('online')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    @if ($errors->has('payment_total'))
                                        <div class="text-danger">
                                            {{ $errors->first('payment_total') }}
                                        </div>
                                    @endif
                                </div>
                                <div class="row" id="emi_terms">
                                    <div class="col-lg-3 mb-3">
                                        <label for="no_of_month" class="form-label">No of months</label>
                                        <input type="text" name="no_of_month" id="no_of_month" class="form-control"
                                            value="{{ old('no_of_month') }}">
                                        @error('no_of_month') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                    <div class="col-lg-3 mb-3">
                                        <label for="interest_rate" class="form-label">Interest Rate(%)</label>
                                        <input type="number" name="interest_rate" id="interest_rate"
                                            class="form-control" value="{{ old('interest_rate') }}">
                                        @error('interest_rate') <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-3 mb-3">
                                        <label for="penalty_amount" class="form-label">Penalty Per Day</label>
                                        <input type="number" name="penalty_amount" id="penalty_amount"
                                            class="form-control" value="{{ old('penalty_amount') }}">
                                        @error('penalty_amount') <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-3 mb-3">
                                        <label for="start_date" class="form-label">EMI Start Date</label>
                                        <input type="date" name="start_date" id="start_date" class="form-control"
                                            value="{{ old('start_date') }}">
                                        @error('start_date') <span class="text-danger">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                            </div>
                         
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Save</button>
                                <a href="{{ route('invoice-emi-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        // Product data from backend
        const products = @json($products);
        const taxes = @json($all_taxes);
        const defaultTaxIds = @json($default_taxes);        

        let rowCount = 0;

        function preventFormSubmit(event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                addProductRow();
                setTimeout(() => {
                    document.getElementById('product-code-input').focus();
                }, 1000);
            }
        }

        function addRow(event) {
            event.preventDefault();
            addProductRow();
            setTimeout(() => {
                document.getElementById('product-code-input').focus();
            }, 1000);
        }

        function addProductRow() {
    const productCode = document.getElementById('product-code-input').value;
    if (!productCode) {
        addEmptyRow();
        return;
    }
    
    const product = products.find(p => p.code === productCode);
    if (product) {
        const existingRow = findProductRow(product.id);
        
        if (existingRow) {
            const qtyInput = existingRow.querySelector('.qty');
            const currentQty = parseFloat(qtyInput.value) || 0;
            qtyInput.value = currentQty + 1;
            calculateRowAmount(existingRow.id.split('-')[1]); 
            checkQuantity(existingRow.id.split('-')[1]);
        } else {
            addProductToTable(product);
        }
        
        document.getElementById('product-code-input').value = '';
    } else {
        alert('Product not found!');
    }
}
function findProductRow(productId) {
    const rows = document.querySelectorAll('#productRows tr');
    for (const row of rows) {
        const select = row.querySelector('.product-select');
        if (select && select.value == productId) {
            return row;
        }
    }
    return null;
}


    function addEmptyRow() {
            rowCount++;
            const row = `
                <tr id="row-${rowCount}">
                    <td>${rowCount}</td>
                    <td>
                        <select name="dynamicFields[${rowCount}][product]" class="form-select product-select" 
                                onchange="updateProductDetails(${rowCount})">
                            <option value="">Select Product</option>
                            ${products.map(p => `<option value="${p.id}">${p.code}-${p.name}</option>`).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][avl_qty]" class="form-control avl-qty" readonly />
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][qty]" class="form-control qty" 
                               onchange="calculateRowAmount(${rowCount})"  oninput="checkQuantity(${rowCount})" />
                                <div class="invalid-feedback quantity-error" style="display: none;">
                        Quantity exceeds available stock!
                    </div>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][unit_price]" class="form-control unit-price" 
                               onchange="calculateRowAmount(${rowCount})" />
                    </td>
                   <td style="min-width: 200px;">
        <select name="dynamicFields[${rowCount}][tax][]" class="form-select tax-select" multiple
                style="height: auto; min-height: 38px;"
                onchange="calculateRowAmount(${rowCount})">
            ${taxes.map(t => {
        const taxId = t.id; 
        const isDefault = defaultTaxIds.includes(taxId);


        return `<option value="${t.id}" ${isDefault ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
    }).join('')}
        </select>
    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][amount]" class="form-control amount" readonly />
                    </td>
                    <td>
                        <button type="button" onclick="removeRow(${rowCount})" class="btn btn-danger btn-sm">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            document.getElementById('productRows').insertAdjacentHTML('beforeend', row);

            const gstValue = document.getElementById('gst').value;
            if (gstValue === 'N') {
                const taxSelect = document.querySelector(`#row-${rowCount} .tax-select`);
                Array.from(taxSelect.options).forEach(option => option.selected = false);
                taxSelect.disabled = true;
            }
        }


        function addProductToTable(product) {
            rowCount++;
            const row = `
                <tr id="row-${rowCount}">
                    <td>${rowCount}</td>
                    <td>
                        <select name="dynamicFields[${rowCount}][product]" class="form-select product-select" 
                                onchange="updateProductDetails(${rowCount})">
                            <option value="">Select Product</option>
                            ${products.map(p => `<option value="${p.id}" ${p.id == product.id ? 'selected' : ''}>${p.code}-${p.name}</option>`).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][avl_qty]" class="form-control avl-qty" 
                               value="${product.qty}" readonly />
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][qty]" class="form-control qty" 
                               value="1" onchange="calculateRowAmount(${rowCount})"  oninput="checkQuantity(${rowCount})"/>
                                <div class="invalid-feedback quantity-error" style="display: none;">
                        Quantity exceeds available stock!
                    </div>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][unit_price]" class="form-control unit-price" 
                               value="${product.unit_price}" onchange="calculateRowAmount(${rowCount})" />
                    </td>
                    <td style="min-width: 200px;">
                        <select name="dynamicFields[${rowCount}][tax][]" class="form-select tax-select" multiple
                                style="height: auto; min-height: 38px;"
                                onchange="calculateRowAmount(${rowCount})">
                            ${taxes.map(t => {
                                const isDefault = defaultTaxIds.includes(t.id);
                                const isProductTax = product.taxes ? product.taxes.includes(t.id) : false;
                                const shouldSelect = isDefault || isProductTax;
                                return `<option value="${t.id}" ${shouldSelect ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
                            }).join('')}
                        </select>
                    </td>
                    <td style="width:120px;">
                        <input type="text" name="dynamicFields[${rowCount}][amount]" class="form-control amount" 
                               value="${product.unit_price}" readonly />
                    </td>
                    <td>
                        <button type="button" onclick="removeRow(${rowCount})" class="btn btn-danger btn-sm">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
            `;
            document.getElementById('productRows').insertAdjacentHTML('beforeend', row);

            calculateRowAmount(rowCount);
            checkQuantity(rowCount);

            const gstValue = document.getElementById('gst').value;
            if (gstValue === 'N') {
                const taxSelect = document.querySelector(`#row-${rowCount} .tax-select`);
                Array.from(taxSelect.options).forEach(option => option.selected = false);
                taxSelect.disabled = true;
                calculateRowAmount(rowCount);
            }
        }

        function updateProductDetails(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const productId = row.querySelector('.product-select').value;
            const product = products.find(p => p.id == productId);

            if (product) {
                row.querySelector('.avl-qty').value = product.qty;
                row.querySelector('.qty').value = 1;
                row.querySelector('.unit-price').value = product.unit_price;
                calculateRowAmount(rowId);
                checkQuantity(rowId);
            }
        }

        function calculateRowAmount(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const qty = parseFloat(row.querySelector('.qty').value) || 0;
            const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
            const amount = qty * unitPrice;

            // Calculate tax
            const taxSelect = row.querySelector('.tax-select');
            const selectedTaxes = Array.from(taxSelect.selectedOptions).map(opt => parseInt(opt.value));
            let taxRate = 0;

            selectedTaxes.forEach(taxId => {
                const tax = taxes.find(t => t.id == taxId);
                if (tax) taxRate += tax.value;
            });

            const taxAmount = amount * (taxRate / 100);
            const totalWithTax = amount + taxAmount;

            row.querySelector('.amount').value = amount.toFixed(2);
            calculateTotal();
        }

        function calculateTotal() {
            let subTotal = 0;
            let totalTax = 0;

            document.querySelectorAll('#productRows tr').forEach(row => {
                const amount = parseFloat(row.querySelector('.amount').value) || 0;
                const qty = parseFloat(row.querySelector('.qty').value) || 0;
                const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
                const rowAmount = qty * unitPrice;

                subTotal += rowAmount;

                // Calculate tax for this row
                const taxSelect = row.querySelector('.tax-select');
                const selectedTaxes = Array.from(taxSelect.selectedOptions).map(opt => parseInt(opt.value));
                let taxRate = 0;

                selectedTaxes.forEach(taxId => {
                    const tax = taxes.find(t => t.id == taxId);
                    if (tax) taxRate += tax.value;
                });

                totalTax += rowAmount * (taxRate / 100);
            });

            // Calculate discount
            const discountType = document.getElementById('discount_type').value;
            const discountValue = parseFloat(document.getElementById('discount').value) || 0;
            let discountAmount = 0;

            var subtotalWithTax = subTotal +totalTax;

            if (discountType == 1) {
                discountAmount = discountValue;
            } else if (discountType == 2) {
                discountAmount = subtotalWithTax * (discountValue / 100);
            }

            const total = subtotalWithTax - discountAmount;

            // Update display
            document.getElementById('subTotalDisplay').textContent = subTotal.toFixed(2) + ' ₹';
            document.getElementById('discountDisplay').textContent = discountAmount.toFixed(2) + ' ₹';
            document.getElementById('taxDisplay').textContent = totalTax.toFixed(2) + ' ₹';
            document.getElementById('totalDisplay').textContent = total.toFixed(2) + ' ₹';

            // Update hidden fields
            document.getElementById('sub_total').value = subTotal.toFixed(2);
            document.getElementById('discount_amt').value = discountAmount.toFixed(2);
            document.getElementById('tax').value = totalTax.toFixed(2);
            document.getElementById('total_amt').value = total.toFixed(2);
        }

        function checkQuantity(rowId) {
        const row = document.getElementById(`row-${rowId}`);
        const qtyInput = row.querySelector('.qty');
        const avlQty = parseFloat(row.querySelector('.avl-qty').value) || 0;
        const qty = parseFloat(qtyInput.value) || 0;
        const errorElement = row.querySelector('.quantity-error');
        
        if (qty > avlQty) {
            qtyInput.classList.add('is-invalid');
            errorElement.style.display = 'block';
            hasQuantityError = true;
            return false;
        } else {
            qtyInput.classList.remove('is-invalid');
            errorElement.style.display = 'none';
            
            // Check if all other rows are also valid
            hasQuantityError = false;
            document.querySelectorAll('#productRows tr').forEach(r => {
                const rQtyInput = r.querySelector('.qty');
                const rAvlQty = parseFloat(r.querySelector('.avl-qty').value) || 0;
                const rQty = parseFloat(rQtyInput?.value) || 0;
                
                if (rQty > rAvlQty) {
                    hasQuantityError = true;
                }
            });
            
            return true;
        }
    }
    function validateForm(event) {
        // First check all quantities
        document.querySelectorAll('#productRows tr').forEach(row => {
            const rowId = row.id.split('-')[1];
            checkQuantity(rowId);
        });
        
        if (hasQuantityError) {
            event.preventDefault();
            Swal.fire({
                icon: 'error',
                title: 'Quantity Error',
                text: 'Please fix quantity errors before submitting. Some items have quantity greater than available stock.',
                confirmButtonText: 'OK',
            });
            return false;
        }
        
        return true;
    }

        function toggleTaxes() {
        const gstValue = document.getElementById('gst').value;
        const taxSelects = document.querySelectorAll('.tax-select');

        taxSelects.forEach(select => {
            if (gstValue === 'N') {
                $(select).val(null).trigger('change');
                select.disabled = true;
            } else {
                select.disabled = false;

                $(select).val(defaultTaxIds.map(String)).trigger('change');
            }
        });

        calculateTotal();
    }

        function toggleNotesAndTerms() {
            const section = document.getElementById('notesTermsSection');
            const btn = document.getElementById('notesTermsBtn');

            if (section.style.display === 'none') {
                section.style.display = 'flex';
                btn.innerHTML = '<i class="fas fa-minus"></i> remove Note & Term';
            } else {
                section.style.display = 'none';
                btn.innerHTML = '<i class="fas fa-plus"></i> Add Note & Term';
            }
        }

        function removeRow(rowId) {
            document.getElementById(`row-${rowId}`).remove();
            calculateTotal();
        }

        $(document).ready(function() {
            $('#client_num_select').select2({
                placeholder: "Search or type a number",
                allowClear: true,
                tags: true,
                tokenSeparators: [',', ' '],
                width: '100%',
                createTag: function(params) {
                    // Don't allow empty tags
                    if (params.term.trim() === '') {
                        return null;
                    }

                    return {
                        id: params.term,
                        text: params.term
                    };
                }
            });     

            document.getElementById('invoice_date').valueAsDate = new Date();
            document.getElementById('due_date').valueAsDate = new Date();

            document.getElementById('discount_type').addEventListener('change', function() {
                document.getElementById('discount').readOnly = !this.value;
                calculateTotal();
            });
            document.querySelector('form').addEventListener('submit', validateForm);
        });
        $(document).ready(function() {
            $('#status').on('change', function() {
                var selectedOption = $(this).find(':selected');
                var statusName = selectedOption.data('name');
                
                if (statusName == 'Paid') {
                    $('#emi_terms input').prop('disabled', true);
                } else {
                    $('#emi_terms input').prop('disabled', false);
                }
            });
        });
        $(document).ready(function () {
    let existingClientNumbers = $("#client_num_select option").map(function () {
        return $(this).val();
    }).get();

    $(document).ready(function () {
    let existingClientNumbers = $("#client_num_select option").map(function () {
        return $(this).val();
    }).get();

    $("#client_num_select").on("change", function () {
        let selectedNumbers = $(this).val() || [];
        let errorElement = $("#client_num_error");
        
        // Check if empty
        if (selectedNumbers.length === 0) {
            errorElement.text("Please select or enter a client number").show();
            return;
        } else {
            errorElement.hide();
        }

        let hasNewNumber = selectedNumbers.some(num => !existingClientNumbers.includes(num));

        if (hasNewNumber) {
            $("#client_name").prop("required", true);
            $("#client_name_error").text("Please enter Client Name").show();
        } else {
            $("#client_name").prop("required", false); 
            $("#client_name_error").hide();
        }
    });

    $('form').on('submit', function(e) {
        let selectedNumbers = $("#client_num_select").val() || [];
        let errorElement = $("#client_num_error");
        
        if (selectedNumbers.length === 0) {
            errorElement.text("Please select or enter a client number").show();
            e.preventDefault();
            
            // Scroll to the error
            $('html, body').animate({
                scrollTop: errorElement.offset().top - 100
            }, 500);
            
            return false;
        }
        return true;
    });

    $("#client_name").on("input", function () {
        if ($(this).val().trim() !== "") {
            $("#client_name_error").hide();
        }
    });
});    
});
    </script>
@endpush