@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add New Expense</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('expense-store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6 mb-3">
                                    <label for="category" class="form-label">Category:</label>
                                    <select class="form-select" name="expense_category_id" required>
                                        <option value="" selected>Select Expense Category</option>
                                        @foreach ($expense_category as $category)
                                            <option value="{{ $category->id }}" {{ old('expense_category_id') == $category->id ? 'selected' : '' }}>
                                                {{ $category->category_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('expense_category_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="expenseName" class="form-label">Expense Name:</label>
                                    <input type="text" id="expenseName" class="form-control" name="expense_name"
                                        value="{{ old('expense_name') }}" placeholder="Enter Expense Name" required>
                                    @error('expense_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="expenseAmount" class="form-label">Amount:</label>
                                    <input type="number" id="expenseAmount" class="form-control" name="expense_amount"
                                        value="{{ old('expense_amount') }}" placeholder="Enter Expense Amount" required>
                                    @error('expense_amount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="expense_date" class="form-label">Expense Date:</label>
                                    <input type="date" id="expense_date" class="form-control" name="expense_date"
                                        value="{{ old('expense_date', date('Y-m-d')) }}">
                                    @error('expense_date')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-12 mb-3">
                                    <label for="attachment" class="form-label">Attachment:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-upload me-5">
                                            <div class="avatar-preview">
                                                <img id="attachmentPreview" src="{{ asset('assets/img/logos/attach.png') }}"
                                                    alt="Default Attachment" class="img-fluid"
                                                    style="height:50px; width:50px">
                                            </div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type="file" id="attachment" class="form-control file-upload-input"
                                                name="attachment" accept="image/*,application/pdf"
                                                onchange="previewFile(this)">
                                        </div>
                                    </div>
                                    @error('attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="d-flex justify-content-end mt-4">
                                <button type="submit" class="btn btn-primary me-2">Save Expense</button>
                                <a href="{{ route('expense-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function previewFile(input) {
            const preview = document.getElementById('attachmentPreview');
            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                if (file.type.includes('image')) {
                    preview.src = reader.result;
                } else if (file.type.includes('pdf')) {
                    preview.src = "{{ asset('assets/img/logos/pdf.png') }}";
                } else {
                    preview.src = "{{ asset('assets/img/logos/file.png') }}";
                }
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                preview.src = "{{ asset('assets/img/logos/attach.png') }}";
            }
        }
    </script>
@endpush