@extends('layouts.layoutapp')

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Update Client</h5>
                </div>
                <div class="card-body">
                    @isset($client)
                    <form action="{{ route('client-update') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="client_id" id="client_id" value="{{$client->id}}">
                        <div class="row">
                            <div class="col-lg-6 row">
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_first_name" class="form-label">First Name:</label>
                                    <input type="text" id="edit_first_name" name="first_name" class="form-control" 
                                           value="{{ old('first_name', $client->user->name) }}" placeholder="Enter first name" required>
                                    @error('first_name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_last_name" class="form-label">Last Name:</label>
                                    <input type="text" id="edit_last_name" name="last_name" class="form-control" 
                                           value="{{ old('last_name', $client->user->last_name) }}" placeholder="Enter last name" required>
                                    @error('last_name') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_email" class="form-label">Email:</label>
                                    <input type="email" id="edit_email" name="email" class="form-control" 
                                           value="{{ old('email', $client->user->email) }}" placeholder="Enter email address" required>
                                    @error('email') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_contact_no" class="form-label">Contact No:</label>
                                    <input type="number" id="edit_contact_no" name="contact_no" class="form-control" 
                                           value="{{ old('contact_no', $client->user->phone) }}" placeholder="Enter contact number" required>
                                    @error('contact_no') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_website" class="form-label">Website:</label>
                                    <input type="text" id="edit_website" name="website" class="form-control" 
                                           value="{{ old('website', $client->website) }}" placeholder="Enter website URL (optional)">
                                    @error('website') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_postal_code" class="form-label">Postal Code:</label>
                                    <input type="number" id="edit_postal_code" name="postal_code" class="form-control" 
                                           value="{{ old('postal_code', $client->postal_code) }}" placeholder="Enter postal code" required>
                                    @error('postal_code') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_country" class="form-label">Country:</label>
                                    <select id="edit_country" name="country" class="form-control" required 
                                            onchange="getEditStates(this.value, '{{ $client->state_id }}')">
                                        <option value="" selected>Select country</option>
                                        @foreach ($countries as $country)
                                            <option value="{{ $country->id }}" 
                                                {{ $country->id == $client->country_id ? 'selected' : '' }}>
                                                {{ $country->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('country') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_state" class="form-label">State:</label>
                                    <select id="edit_state" name="state" class="form-select" required 
                                            onchange="getEditCities(this.value, '{{ $client->city_id }}')">
                                        <option value="" selected>Select state</option>
                                        @foreach ($states as $state)
                                            <option value="{{ $state->id }}" 
                                                {{ $state->id == $client->state_id ? 'selected' : '' }}>
                                                {{ $state->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('state') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_city" class="form-label">City:</label>
                                    <select id="edit_city" name="city" class="form-select" required>
                                        <option value="" selected>Select city</option>
                                        @foreach ($cities as $city)
                                            <option value="{{ $city->id }}" 
                                                {{ $city->id == $client->city_id ? 'selected' : '' }}>
                                                {{ $city->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('city') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_company_name" class="form-label">Company Name:</label>
                                    <input type="text" id="edit_company_name" name="company_name" class="form-control" 
                                           value="{{ old('company_name', $client->company_name) }}" placeholder="Enter company name" required>
                                    @error('company_name') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                            </div>
                            <div class="col-lg-6 row">
                                <div class="col-12 mb-7">
                                    <label for="edit_profile_image" class="form-label">Profile:</label>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-upload me-5">
                                            <div class="avatar-preview">
                                                <img id="editProfilePreview" src="{{ $client->profile_img ? getFileUrl($client->profile_img) : asset('assets/img/logos/profile.png') }}" 
                                                     alt="Profile Image" class="img-fluid rounded-circle" style="height:125px;">
                                            </div>
                                        </div>
                                        <div class="avatar-edit">
                                            <input type="file" id="edit_profile_image" name="profile_image" 
                                                   class="form-control file-upload-input" accept="image/*" onchange="previewEditImage(this)">
                                        </div>
                                    </div>
                                    @error('profile_image') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_address" class="form-label">Address:</label>
                                    <input type="text" id="edit_address" name="address" class="form-control" 
                                           value="{{ old('address', $client->address) }}" placeholder="Enter full address" required>
                                    @error('address') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_notes" class="form-label">Notes:</label>
                                    <input type="text" id="edit_notes" name="notes" class="form-control" 
                                           value="{{ old('notes', $client->note) }}" placeholder="Enter any notes (optional)">
                                    @error('notes') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_gstin" class="form-label">GSTIN:</label>
                                    <input type="text" id="edit_gstin" name="gstin" class="form-control" 
                                           value="{{ old('gstin', $client->gstin) }}" placeholder="Enter GSTIN number (optional)">
                                    @error('gstin') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 mb-3">
                                    <label for="edit_active_status" class="form-label">Active Status:</label>
                                    <select id="edit_active_status" name="active_status" class="form-select">
                                        <option value="A" {{ $client->active_status == 'A' ? 'selected' : '' }}>Active</option>
                                        <option value="I" {{ $client->active_status == 'I' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                    @error('active_status') <span class="text-danger">{{$message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12 text-end">
                                <button type="submit" class="btn btn-primary">Update Client</button>
                                <a href="{{ route('client-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>
                    </form>
                    @else
                    <div class="alert alert-danger">
                        Client data not found!
                    </div>
                    @endisset
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function previewEditImage(input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                document.getElementById('editProfilePreview').src = e.target.result;
            }
            reader.readAsDataURL(input.files[0]);
        }
    }

    function getEditStates(countryId, selectedStateId = null) {
        if (!countryId) {
            document.getElementById('edit_state').innerHTML = '<option value="">Select state</option>';
            document.getElementById('edit_city').innerHTML = '<option value="">Select city</option>';
            return;
        }

        fetch(`/getStates/${countryId}`)
            .then(response => response.json())
            .then(data => {
                const stateSelect = document.getElementById('edit_state');
                stateSelect.innerHTML = '<option value="">Select state</option>';
                data.forEach(state => {
                    const selected = state.id == selectedStateId ? 'selected' : '';
                    stateSelect.innerHTML += `<option value="${state.id}" ${selected}>${state.name}</option>`;
                });
                
                // If a state was pre-selected, trigger city loading
                if (selectedStateId) {
                    getEditCities(selectedStateId, '{{ $client->city_id ?? null }}');
                }
            });
    }

    function getEditCities(stateId, selectedCityId = null) {
        if (!stateId) {
            document.getElementById('edit_city').innerHTML = '<option value="">Select city</option>';
            return;
        }

        fetch(`/getCities/${stateId}`)
            .then(response => response.json())
            .then(data => {
                const citySelect = document.getElementById('edit_city');
                citySelect.innerHTML = '<option value="">Select city</option>';
                data.forEach(city => {
                    const selected = city.id == selectedCityId ? 'selected' : '';
                    citySelect.innerHTML += `<option value="${city.id}" ${selected}>${city.name}</option>`;
                });
            });
    }

    // Initialize states and cities when page loads if country is selected
    document.addEventListener('DOMContentLoaded', function() {
        const countrySelect = document.getElementById('edit_country');
        if (countrySelect && countrySelect.value) {
            getEditStates(countrySelect.value, '{{ $client->state_id ?? null }}');
        }
    });
</script>
@endsection