<?php

namespace App\Providers;

use App\Models\WhatsappConfigModel;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class WhatsAppService
{
    protected $apiUrl;
    protected $accessToken;
    protected $phoneNumberId;

    public function __construct()
    {
        $whatsapp_config = WhatsappConfigModel::first();
        $this->apiUrl = $whatsapp_config->whatsapp_api_url;
        $this->accessToken = $whatsapp_config->whatsapp_access_token;
        $this->phoneNumberId = $whatsapp_config->whatsapp_phone_number_id;
    }

    public function sendWhatsAppMessage($phone, $invoiceNumber, $amount)
    {
        try {
            $response = Http::withHeaders([
                'Content-Type' => 'application/json',
            ])->post($this->apiUrl, [
                        "from_phone_number_id" => $this->phoneNumberId,
                        "phone_number" => $phone,
                        "template_name" => "order_invoice_notification",
                        "template_language" => "en",
                        "header_document_name" => "order_invoice_notification",
                        "location_latitude" => "22.22",
                        "location_longitude" => "22.22",
                        "field_1" => $phone,
                        "field_2" => $invoiceNumber,
                        "field_3" => $amount,
                    ]);

            $responseBody = $response->json();
            Log::info("WhatsApp Response: ", $responseBody);

            if (!$response->successful()) {
                Log::error('WhatsApp API Error: ' . $response->body());
                return false;
            }

            return true;

        } catch (\Exception $e) {
            Log::error("WhatsApp API Error: " . $e->getMessage());
            return ['error' => $e->getMessage()];
        }
    }

}