<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RightsModel extends Model
{
    use HasFactory;

    protected $table= 'rights';
    protected $primary_key ='id';

    protected $fillable = ['created_by'];
    public function rightDetails()
    {
        return $this->hasMany(RightsDetailModel::class,'rights_id','id');
    }

    public function menus()
    {
        return $this->hasManyThrough(MenuModel::class, RightsDetailModel::class, 'rights_id', 'id', 'id', 'menu_id');
    }

}
