<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ExpensesModel extends Model
{
    use HasFactory;
    protected $table = 'expense';
    protected $primaryKey = 'id';
    protected $fillable = [
        'expense_category_id',
        'expense_name',
        'expense_amount',
        'expense_date',
        'expense_attachment',
        'branch_id',
    ];
    public function exp_category()
    {
        $category = DB::table('expense_category')
            ->where('id', $this->expense_category_id)
            ->value('category_name');

        return $category;
    }
    public function category()
    {
        return $this->belongsTo(ExpenseCategory::class, 'expense_category_id');
    }
}
