<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BranchModel extends Model
{
    use HasFactory;

    protected $table = 'branch';
    public $timestamps = true;

    protected $primaryKey = 'id';
    protected $fillable = [
        'company_id',
        'name',
        'address',
        'phone',
        'company_name',
        'logo',
        'gst_no',
        'email',
        'prefix',
        'whatsapp_config',
        'paper_size',
        'loyalty_config',
        'loyalty_amount',
        'declaration',
    ];

    /**
     * Get the company that owns the branch.
     */
    public function company()
    {
        return $this->belongsTo(CompanyModel::class);
    }

    /**
     * Get all users associated with the branch.
     */
    public function users()
    {
        return $this->belongsToMany(User::class, 'branch_user', 'branch_id', 'user_id');
    }

    public function paper()
    {
        return $this->belongsTo(StandardPaperSizeModel::class, 'paper_size');
    }
}
